/*

 */
package com.paypal.hybris.core.service;

import com.paypal.hybris.data.PayPalConnectUserData;

/**
 * This interface is used to work with user data by access token
 */
public interface PayPalConnectService {

    /**
     * This method is used to exchange AuthorizationCode To Access Token
     * @param authorizationToken authorizationToken
     * @return exchanged AuthorizationCode
     */
    String exchangeAuthorizationCodeToAccessToken(String authorizationToken);

    /**
     * This method is used to get PayPalConnectUserData by accessToken
     * @param accessToken access token
     * @return PayPalConnectUserData
     */
    PayPalConnectUserData getUserDataByAccessToken(String accessToken);

}
