/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalPaymentInfoDao;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.servicelayer.internal.dao.AbstractItemDao;
import de.hybris.platform.servicelayer.search.SearchResult;
import de.hybris.platform.servicelayer.util.ServicesUtil;
import java.util.HashMap;
import java.util.Map;

public class DefaultPayPalPaymentInfoDao extends AbstractItemDao implements PayPalPaymentInfoDao {

    @Override
    public PayPalCreditCardPaymentInfoModel find(final String payerId, final String billingAgreementId) {
        ServicesUtil.validateParameterNotNull(payerId, "payerId must not be null");
        ServicesUtil.validateParameterNotNull(billingAgreementId, "billingAgreementId must not be null");
        final Map queryParams = new HashMap();
        queryParams.put("payerId", payerId);
        queryParams.put("billingAgreementId", billingAgreementId);
        queryParams.put("duplicate", Boolean.FALSE);

        final SearchResult result = getFlexibleSearchService().search(
            "SELECT {pk} FROM {PayPalCreditCardPaymentInfo} WHERE {payerId}=?payerId "
                + "AND {billingAgreementId}=?billingAgreementId AND {duplicate}=?duplicate", queryParams);

        return ((result.getCount() > 0) ? (PayPalCreditCardPaymentInfoModel) result.getResult().get(0) : null);
    }

}
