/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalCustomerAccountDao;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.commerceservices.customer.dao.impl.DefaultCustomerAccountDao;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.search.SearchResult;
import de.hybris.platform.servicelayer.util.ServicesUtil;
import java.util.HashMap;
import java.util.Map;

public class DefaultPayPalCustomerAccountDao extends DefaultCustomerAccountDao implements PayPalCustomerAccountDao {

    private static final String CUSTOMER_MUST_NOT_BE_NULL = "Customer must not be null";
    private static final String PAYER_ID_MUST_NOT_BE_NULL = "Payer id must not be null";

    public CustomerModel findCustomerByBillingAgreementId(final String billingAgreementId) {
        ServicesUtil.validateParameterNotNull(billingAgreementId, CUSTOMER_MUST_NOT_BE_NULL);
        final Map queryParams = new HashMap();
        queryParams.put("billingAgreementId", billingAgreementId);
        queryParams.put("duplicate", false);

        final SearchResult result = getFlexibleSearchService().search(
            "SELECT {customer:" + CustomerModel.PK + "} FROM {"
                + CustomerModel._TYPECODE + " as customer JOIN " + PayPalCreditCardPaymentInfoModel._TYPECODE +
                " as paypalPaymentInfo" + " ON {customer:" + CustomerModel.PK
                + "} = {paypalPaymentInfo:" +
                PayPalCreditCardPaymentInfoModel.USER + "}} " + "WHERE {paypalPaymentInfo:" +
                PayPalCreditCardPaymentInfoModel.BILLINGAGREEMENTID + "} = ?billingAgreementId" +
                " AND {paypalPaymentInfo:" + PayPalCreditCardPaymentInfoModel.DUPLICATE + "} = ?duplicate", queryParams);
        return ((result.getCount() > 0) ? (CustomerModel) result.getResult().get(0) : null);
    }

    @Override
    public CustomerModel findCustomerByPayPalPayerId(String payerId) {
        ServicesUtil.validateParameterNotNull(payerId, PAYER_ID_MUST_NOT_BE_NULL);
        final Map queryParams = new HashMap();
        queryParams.put("payPalPayerId", payerId);

        final SearchResult result = getFlexibleSearchService().search(
            "SELECT {" + CustomerModel.PK + "} FROM {" + CustomerModel._TYPECODE + "} WHERE {"
                + CustomerModel.PAYPALPAYERID
                + "} = ?payPalPayerId", queryParams);
        return ((result.getCount() > 0) ? (CustomerModel) result.getResult().get(0) : null);
    }
}
