/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalCartToOrderCronJobDao;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.internal.dao.AbstractItemDao;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPayPalCartToOrderCronJobDao extends AbstractItemDao implements PayPalCartToOrderCronJobDao {

        protected static final String GET_CRON_JOB_BY_BILLING_AGREEMENT =
            "SELECT {cronJob:" + CartToOrderCronJobModel.PK + "} FROM {"
                + CartToOrderCronJobModel._TYPECODE + " as cronJob JOIN " + PayPalCreditCardPaymentInfoModel._TYPECODE +
                " as payPalPaymentInfo" + " ON {cronJob:" + CartToOrderCronJobModel.PAYMENTINFO
                + "} = {payPalPaymentInfo:" +
                PayPalCreditCardPaymentInfoModel.PK + "}} " + "WHERE {payPalPaymentInfo:" +
                PayPalCreditCardPaymentInfoModel.BILLINGAGREEMENTID + "} = ?billingAgreement" +
                " AND {payPalPaymentInfo:" + PayPalCreditCardPaymentInfoModel.DUPLICATE + "} = ?duplicate";

        @Override
        public List<CartToOrderCronJobModel> findCronJobsByBillingAgreement(String billingAgreement) {
            final Map<String, Object> params = new HashMap<String, Object>();
            params.put("billingAgreement", billingAgreement);
            params.put("duplicate", Boolean.FALSE);
            final FlexibleSearchQuery flexibleSearchQuery = new FlexibleSearchQuery(GET_CRON_JOB_BY_BILLING_AGREEMENT);
            flexibleSearchQuery.addQueryParameters(params);
            flexibleSearchQuery.setResultClassList(Collections.singletonList(CartToOrderCronJobModel.class));
            final SearchResult<CartToOrderCronJobModel> searchResult = search(flexibleSearchQuery);
            return searchResult.getResult();
        }

}
