package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalCartDao;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.commerceservices.order.dao.impl.DefaultCommerceCartDao;
import de.hybris.platform.core.enums.CreditCardType;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.servicelayer.search.SearchResult;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class DefaultPayPalCartDao extends DefaultCommerceCartDao implements PayPalCartDao {

    private static final String PAYPAL_ORDER_ID = "payPalOrderId";

    protected static final String GET_CART_BY_ORDER_ID =
        "SELECT {pk} FROM {" + CartModel._TYPECODE + " as cart "
            + "JOIN " + PayPalCreditCardPaymentInfoModel._TYPECODE + " as pi ON {cart:" + CartModel.PAYMENTINFO
            + "}={pi:pk} "
            + "JOIN " + CreditCardType._TYPECODE + " as cct ON {pi.type}={cct.pk}} "
            + "WHERE {pi:" + PayPalCreditCardPaymentInfoModel.SUBSCRIPTIONID + "} = ?payPalOrderId "
            + "AND {cct.code} = \"" + CreditCardType.LOCAL_PAYMENT.getCode() + "\"";

    @Override
    public CartModel getCartForPayPalOrderId(String payPalOrderId) {
        final Map<String, Object> params = new HashMap<String, Object>();
        params.put(PAYPAL_ORDER_ID, payPalOrderId);
        final SearchResult<CartModel> searchResult = search(
            createSearchQuery(GET_CART_BY_ORDER_ID, params, CartModel.class));
        final List<CartModel> carts = searchResult.getResult();

        return carts.stream().findFirst().orElse(null);
    }
}
