/*
 * [y] hybris Platform
 *
 * Copyright (c) 2018 SAP SE or an SAP affiliate company. All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */
package com.paypal.hybris.core.constants;

/**
 * Global class for all Paypalcore constants. You can add global constants for your extension into this class.
 */
public final class PaypalcoreConstants extends GeneratedPaypalcoreConstants {

    public static final String EXTENSIONNAME = "paypalcore";
    public static final String PAYPAL_PROVIDER_NAME = "PayPal";

    public static final String PAYPAL_INTENT_AUTHORIZE = "authorize";
    public static final String PAYPAL_INTENT_CAPTURE = "capture";

    public static final String AUTHORIZATION_HEADER = "Authorization";

    public static final String PAYPAL_ORDER_ID_PLACEHOLDER = "ORDER_ID_PLACEHOLDER";
    public static final String PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE = "REPLENISHMENT_FLOW";
    public static final String PAYPAL_EXPRESS_BILLING_AGREEMENT_FLOW = "EXPRESS_BILLING_AGREEMENT_FLOW";
    public static final String PAYPAL_ORDER_PROCESS_FLOW = "ORDER_PROCESS_FLOW";
    public static final String PAYPAL_INTENT_CAPTURE_PROCESS_FLOW = "CAPTURE_INTENT_FLOW";
    public static final String DEFAULT_FLOW = "DEFAULT_FLOW";
    public static final String PAYPAL_LIVE_ENVIRONMENT = "live";


    public static final String CREATED_STATUS_RESULT = "CREATED";
    public static final String BILLING_AGREEMENT = "BILLING_AGREEMENT";


    // Configuration properties
    public static final String CLIENT_ID = "paypal.client.id";
    public static final String SECRET_KEY = "paypal.secret.key";
    public static final String PAYPAL_ENV_CONFIGURATION = "paypal.environment.configuration.type";
    public static final String PAYPAL_API_URL = "paypal.api.url";
    public static final String PAYPAL_SDK_JS_URL = "paypal.sdk.js.url";
    public static final String PAYPAL_BILLING_AGREEMENT_ENABLED = "paypal.billing.agreement.enabled";
    public static final String PAYPAL_EXPRESS_CHECKOUT_ENABLED = "paypal.express.checkout.enabled";
    public static final String PAYPAL_INTENT = "paypal.intent";
    public static final String PAYPAL_DISABLE_FUNDING_CART_PAGE = "paypal.disable.funding.cart.page";
    public static final String PAYPAL_DISABLE_FUNDING_MINI_CART = "paypal.disable.funding.mini.cart";
    public static final String PAYPAL_DISABLE_FUNDING_MARK_PAGE = "paypal.disable.funding.mark.page";
    public static final String PAYPAL_CUSTOM_BILLING_AGREEMENT_DESCRIPTION = "paypal.custom.billing.agreement.description";
    public static final String PAYPAL_PARTNER_ATTRIBUTION_ID = "paypal.partner.attribution.id";
    public static final String PAYPAL_VENMO_ENABLED = "paypal.venmo.enabled";
    public static final String PAYPAL_PAYLATER_FOR_NON_US_COUNTRIES = "paypal.paylater.for.non.us.countries";
    public static final String PAYPAL_NONDECIMAL_CURRENCY = "paypal.nondecimal.currency";
    public static final String PAYPAL_CONNECT_SCRIPT = "paypal.connect.script";
    public static final String PAYPAL_CONNECT_SCOPES = "paypal.connect.scopes";
    public static final String PAYPAL_CONNECT_RESPONSE_TYPE = "paypal.connect.responseType";
    public static final String PAYPAL_CONNECT_RETURN_URL = "paypal.connect.returnUrl";
    public static final String PAYPAL_CONNECT_CHECKOUT_RETURN_URL = "paypal.connect.checkout.returnUrl";

    public static final String PAYPAL_ACCEPTED_PAYMENT_METHODS = "paypal.accepted.payment.methods";
    public static final String PAYPAL_ACCEPTED_PAYMENT_METHODS_DELIMETER = ";";
    public static final String PAYPAL_EMPTY_STRING = "";
    public static final String PAYPAL_COMMA = ",";
    public static final int PAYPAL_TEMP_PASSWORD_LENGTH = 20;
    public static final String PAYPAL_CHARACTERS_FOR_PASSWORD = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public static final String PAYPAL_IMAGES_PREFIX = "paypal.image.";

    public static final String LPM_FUNDING_LIST = "bancontact,blik,boleto,eps,giropay,ideal,itau,maxima,mercadopago,"
        + "mybank,oxxo,p24,payu,sepa,sofort,trustly,wechatpay,zimpler";
    public static final String PAYPAL_CREDIT_FUNDING = "credit";
    public static final String LOGIN_PAGE_DISABLE_FUNDING_LIST = "bancontact,blik,boleto,eps,giropay,ideal,itau,maxima,mercadopago,"
        + "mybank,oxxo,p24,payu,sepa,sofort,trustly,wechatpay,zimpler,credit,paylater,card";

    public static final String PLATFORM_LOGO_CODE = "paypalcorePlatformLogo";

    private PaypalcoreConstants() {
        //empty to avoid instantiating this constant class
    }

    // implement here constants used by this extension


}
