package com.paypal.hybris.core.commands.impl;

import com.paypal.http.HttpResponse;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.payments.AuthorizationsVoidRequest;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.VoidCommand;
import de.hybris.platform.payment.commands.request.VoidRequest;
import de.hybris.platform.payment.commands.result.VoidResult;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.dto.TransactionStatusDetails;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.util.Optional;


public class DefaultPayPalVoidCommand extends PayPalAbstractCommand implements VoidCommand {

    private static final String CODE_RESPONCE = "204";

    private static final Logger LOG = Logger.getLogger(DefaultPayPalVoidCommand.class);

    @Override
    public VoidResult perform(VoidRequest request) {
        AuthorizationsVoidRequest authorizationsVoidRequest = Optional.ofNullable(request.getRequestId())
            .map(AuthorizationsVoidRequest::new).orElseThrow(()
                -> new IllegalArgumentException(
                "Request ID is undefined, actual Request ID is: " + request.getRequestId()));
        HttpResponse<Void> response = null;
        try {
            response = createClient().execute(authorizationsVoidRequest);
        } catch (IOException e) {
            LOG.error("Transaction cancel failed: ", e);
            throw new AdapterException(getDescriptionFromPayPalErrorMessage(e.getMessage()));
        }
        return translateResponse(response, request);
    }

    private VoidResult translateResponse(HttpResponse<Void> response, VoidRequest request) {
        String resultStatus = Integer.toString(response.statusCode());
        VoidResult result = getVoidResult(request, resultStatus);
        return result;
    }

    private VoidResult getVoidResult(VoidRequest request, String resultStatus) {
        final TransactionStatus transactionStatus = CODE_RESPONCE.equals(resultStatus) ? TransactionStatus.ACCEPTED
            : TransactionStatus.REJECTED;
        final TransactionStatusDetails transactionStatusDetails = CODE_RESPONCE.equals(resultStatus) ?
            TransactionStatusDetails.SUCCESFULL : TransactionStatusDetails.PROCESSOR_DECLINE;

        return GenericBuilder.of(VoidResult::new)
            .with(VoidResult::setAmount, request.getTotalAmount())
            .with(VoidResult::setCurrency, request.getCurrency())
            .with(VoidResult::setRequestId, request.getRequestId())
            .with(VoidResult::setMerchantTransactionCode, request.getMerchantTransactionCode())
            .with(VoidResult::setTransactionStatus, transactionStatus)
            .with(VoidResult::setTransactionStatusDetails, transactionStatusDetails)
            .build();
    }
}
