package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.core.AuthorizationProvider;
import com.paypal.core.PayPalEnvironment;
import com.paypal.core.PayPalHttpClient;
import com.paypal.core.object.AccessToken;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.PayPalIntegrationAmountWithBreakdown;
import com.paypal.hybris.data.PayPalIntegrationPatch;
import com.paypal.hybris.data.PayPalOrderRequestData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class DefaultPayPalUpdateOrderAmountCommand extends PayPalAbstractCommand
    implements Command<PayPalOrderRequestData, Boolean> {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalUpdateOrderAmountCommand.class);

    private static final String PATH = "/purchase_units/@reference_id=='default'/amount";
    private static final String REPLACE = "replace";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final int TIMEOUT = 3000;

    private RestTemplate restTemplate;
    private HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory;

    @Override
    public Boolean perform(final PayPalOrderRequestData orderDetails) {
        List<PayPalIntegrationPatch> patches = new ArrayList<>();
        PayPalIntegrationPatch patch = GenericBuilder.of(PayPalIntegrationPatch::new)
                .with(PayPalIntegrationPatch::setOp, REPLACE)
                .with(PayPalIntegrationPatch::setPath, PATH)
                .with(PayPalIntegrationPatch::setValue,
                        GenericBuilder.of(PayPalIntegrationAmountWithBreakdown::new)
                                .with(PayPalIntegrationAmountWithBreakdown::setCurrencyCode, orderDetails.getCurrency())
                                .with(PayPalIntegrationAmountWithBreakdown::setValue, orderDetails.getAmount())
                                .build())
                .build();
        patches.add(patch);

        Map variable = new HashMap();
        variable.put("id", orderDetails.getOrderId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        PayPalEnvironment payPalEnvironment = createPayPalEnvironment();
        PayPalHttpClient client = createClient();

        httpComponentsClientHttpRequestFactory.setConnectTimeout(TIMEOUT);
        httpComponentsClientHttpRequestFactory.setReadTimeout(TIMEOUT);

        try {
            AccessToken accessToken = AuthorizationProvider.sharedInstance().authorize(client, null);
            headers.set(HttpHeaders.AUTHORIZATION, BEARER_PREFIX + accessToken.accessToken());
            HttpEntity entity = new HttpEntity<>(patches, headers);
            restTemplate.patchForObject(payPalEnvironment.baseUrl() + "/v2/checkout/orders/{id}", entity, Boolean.class, variable);
        } catch (IOException e) {
            LOG.error("Updating Order amount failed: ", e);
            throw new AdapterException(getDescriptionFromPayPalErrorMessage(e.getMessage()));
        }
        return true;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setHttpComponentsClientHttpRequestFactory(HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory) {
        this.httpComponentsClientHttpRequestFactory = httpComponentsClientHttpRequestFactory;
    }
}
