package com.paypal.hybris.core.commands.impl;

import com.paypal.http.HttpResponse;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.data.PayPalAddressDetailsData;
import com.paypal.hybris.data.PayPalOrderRequestData;
import com.paypal.orders.AddressPortable;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.ApplicationContext;
import com.paypal.orders.Name;
import com.paypal.orders.Order;
import com.paypal.orders.OrderRequest;
import com.paypal.orders.OrdersCreateRequest;
import com.paypal.orders.PurchaseUnitRequest;
import com.paypal.orders.ShippingDetail;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


public class DefaultPayPalCreateOrderCommand extends PayPalAbstractCommand
    implements Command<PayPalOrderRequestData, String> {

    private static final String CREATING_ORDER_ERROR_MESSAGE = "ERROR WHILE CREATING ORDER\nException: ";
    private static final String SET_PROVIDED_ADDRESS = "SET_PROVIDED_ADDRESS";
    private static final String NO_SHIPPING = "NO_SHIPPING";

    private static final Logger LOG = Logger.getLogger(DefaultPayPalCreateOrderCommand.class);

    @Override
    public String perform(final PayPalOrderRequestData data) {
        final OrdersCreateRequest createRequest = new OrdersCreateRequest();
        createRequest.requestBody(createOrderRequestBody(data));
        createRequest.payPalPartnerAttributionId(getDefaultPayPalConfigurationService().getPayPalPartnerAttributionId());
        HttpResponse<Order> response = null;
        try {
            response = createClient().execute(createRequest);
        } catch (IOException e) {
            LOG.error(CREATING_ORDER_ERROR_MESSAGE + e);
            throw new AdapterException(getDescriptionFromPayPalErrorMessage(e.getMessage()));
        }
        return response.result().id();
    }

    private OrderRequest createOrderRequestBody(final PayPalOrderRequestData data) {
        OrderRequest requestBody = new OrderRequest();
        ApplicationContext applicationContext = new ApplicationContext();
        PurchaseUnitRequest purchaseUnit = new PurchaseUnitRequest();
        AmountWithBreakdown amountWithBreakdown = new AmountWithBreakdown();
        amountWithBreakdown.currencyCode(data.getCurrency());
        amountWithBreakdown.value(data.getAmount());
        purchaseUnit.amountWithBreakdown(amountWithBreakdown);
        if (data.getShippingAddress() != null) {
            purchaseUnit.shippingDetail(createShippingAddressRequest(data.getShippingAddress()));
            applicationContext.shippingPreference(SET_PROVIDED_ADDRESS);
        } else {
            applicationContext.shippingPreference(NO_SHIPPING);
        }
        requestBody.applicationContext(applicationContext);
        List<PurchaseUnitRequest> purchaseUnits = new ArrayList<>();
        purchaseUnits.add(purchaseUnit);
        requestBody.checkoutPaymentIntent(getDefaultPayPalConfigurationService().getPayPalIntent().toUpperCase());
        requestBody.purchaseUnits(purchaseUnits);

        return requestBody;
    }


    private ShippingDetail createShippingAddressRequest(PayPalAddressDetailsData addressData) {
        Name name = new Name();
        name.fullName(addressData.getFirstName() + " " + addressData.getLastName());
        AddressPortable addressPortable = new AddressPortable();
        addressPortable.addressLine1(addressData.getLine1());
        addressPortable.addressLine2(addressData.getLine2());
        addressPortable.adminArea1(addressData.getRegion());
        addressPortable.adminArea2(addressData.getCity());
        addressPortable.countryCode(addressData.getCountryCode());
        addressPortable.postalCode(addressData.getPostalCode());
        ShippingDetail shippingDetail = new ShippingDetail();
        shippingDetail.addressPortable(addressPortable);
        shippingDetail.name(name);
        return shippingDetail;
    }
}
