package com.paypal.hybris.core.commands.impl;

import com.paypal.base.rest.JSONFormatter;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.PayPalAddressData;
import com.paypal.hybris.data.PayPalAddressDetailsData;
import com.paypal.hybris.data.PayPalBillingAgreementData;
import com.paypal.hybris.data.PayPalBillingAgreementResponse;
import com.paypal.hybris.data.PayPalBillingAgreementTokenData;
import com.paypal.hybris.data.PayPalPayerInfoData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;


public class DefaultPayPalCreateBillingAgreementCommand extends PayPalAbstractCommand
    implements Command<String, PayPalBillingAgreementData> {

    private static final String AGREEMENTS = "billing-agreements/agreements";
    private static final String CREATE_BILLING_AGREEMENT_FAILURE_MESSAGE = "Billing agreement creation failed";

    private static final Logger LOG = Logger.getLogger(DefaultPayPalCreateBillingAgreementCommand.class);

    public PayPalBillingAgreementData perform(final String billingAgreementToken) {

        final RestTemplate restTemplate = new RestTemplate();
        final HttpHeaders headers = new HttpHeaders();
        final String agreementTokenUrl = getPayPalApiEndpoint().concat(AGREEMENTS);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());
        final PayPalBillingAgreementTokenData body = new PayPalBillingAgreementTokenData();
        body.setToken_id(billingAgreementToken);
        final HttpEntity<String> httpEntity = new HttpEntity<>(JSONFormatter.toJSON(body), headers);
        final ResponseEntity<PayPalBillingAgreementResponse> response;
        try {
            response = restTemplate.postForEntity(agreementTokenUrl, httpEntity, PayPalBillingAgreementResponse.class);
        } catch (Exception e) {
            LOG.error(CREATE_BILLING_AGREEMENT_FAILURE_MESSAGE, e);
            throw new AdapterException(e.getMessage());
        }
        return translateResponse(response.getBody());
    }

    private PayPalBillingAgreementData translateResponse(PayPalBillingAgreementResponse responseBody) {
        PayPalPayerInfoData payerInfo = responseBody.getPayer().getPayer_info();

        final PayPalAddressDetailsData billingAddress = payerInfo.getBilling_address() == null
            ? translateAddressResponse(responseBody.getShipping_address())
            : translateAddressResponse(payerInfo.getBilling_address());
								if(billingAddress != null) {
									billingAddress.setFirstName(payerInfo.getFirst_name());
									billingAddress.setLastName(payerInfo.getLast_name());
									billingAddress.setEmail(payerInfo.getEmail());
								}
        final PayPalAddressDetailsData shippingAddress = translateAddressResponse(responseBody.getShipping_address());
        if(shippingAddress != null) {
            shippingAddress.setFirstName(payerInfo.getFirst_name());
            shippingAddress.setLastName(payerInfo.getLast_name());
            shippingAddress.setEmail(payerInfo.getEmail());
        }

        return GenericBuilder.of(PayPalBillingAgreementData::new)
            .with(PayPalBillingAgreementData::setPayerEmail, payerInfo.getEmail())
            .with(PayPalBillingAgreementData::setPayerId, payerInfo.getPayer_id())
            .with(PayPalBillingAgreementData::setPayerName, payerInfo.getFirst_name() + payerInfo.getLast_name())
            .with(PayPalBillingAgreementData::setState, responseBody.getState())
            .with(PayPalBillingAgreementData::setId, responseBody.getId())
            .with(PayPalBillingAgreementData::setBillingAddress, billingAddress)
            .with(PayPalBillingAgreementData::setShippingAddress, shippingAddress)
            .build();
    }

    private PayPalAddressDetailsData translateAddressResponse(final PayPalAddressData addressData) {
        if (addressData == null) {
            return null;
        }
        return GenericBuilder.of(PayPalAddressDetailsData::new)
            .with(PayPalAddressDetailsData::setLine1, addressData.getLine1())
            .with(PayPalAddressDetailsData::setLine2, addressData.getLine2())
            .with(PayPalAddressDetailsData::setCity, addressData.getCity())
            .with(PayPalAddressDetailsData::setRegion, addressData.getState())
            .with(PayPalAddressDetailsData::setPostalCode, addressData.getPostal_code())
            .with(PayPalAddressDetailsData::setCountryCode, addressData.getCountry_code())
            .build();
    }
}
