/*

 */
package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.PayPalConnectUserData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;

import org.springframework.web.client.RestTemplate;

public class DefaultPayPalConnectGetUserInformationCommand extends PayPalAbstractCommand
    implements Command<String, PayPalConnectUserData> {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalConnectGetUserInformationCommand.class);

    private static final String USER_INFO_ENDPOINT_URL = "identity/oauth2/userinfo?schema=paypalv1.1";
    private static final String AUTHORIZATION_HEADER_PREFIX = "Bearer ";
    private static final String ERROR_MESSAGE = "Error during try exchange authorization token to access token";

    @Override
    public PayPalConnectUserData perform(String accessToken) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        String endpointUrl = getPayPalApiEndpoint().concat(USER_INFO_ENDPOINT_URL);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, AUTHORIZATION_HEADER_PREFIX + accessToken);
        HttpEntity<LinkedMultiValueMap<String, String>> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<PayPalConnectUserData> response;
        try {
            response = restTemplate
                .exchange(endpointUrl, HttpMethod.GET, httpEntity, PayPalConnectUserData.class);
        } catch (Exception e) {
            LOG.error(ERROR_MESSAGE, e);
            throw new AdapterException(e.getMessage());
        }
        return response.getBody();
    }
}
