/*

 */
package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.PayPalConnectAccessTokenData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import java.util.Base64;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefaultPayPalConnectExchangeCodeToAccessTokenCommand extends PayPalAbstractCommand
    implements Command<String, PayPalConnectAccessTokenData> {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalConnectExchangeCodeToAccessTokenCommand.class);

    private static final String EXCHANGE_ENDPOINT_URL = "oauth2/token";
    private static final String AUTHORIZATION_HEADER_PREFIX = "Basic ";
    private static final String GRANT_TYPE = "grant_type";
    private static final String GRANT_TYPE_VALUE = "authorization_code";
    private static final String CODE = "code";
    private static final String ERROR_MESSAGE = "Error during try exchange authorization token to access token";

    @Override
    public PayPalConnectAccessTokenData perform(String authorizationCode) {
        MultiValueMap<String, String> map = new LinkedMultiValueMap<>();
        map.add(GRANT_TYPE,GRANT_TYPE_VALUE);
        map.add(CODE,authorizationCode);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        String endpointUrl = getPayPalApiEndpoint().concat(EXCHANGE_ENDPOINT_URL);
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, AUTHORIZATION_HEADER_PREFIX + getAuthorizationHeaderValue());
        HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity<>(map, headers);
        ResponseEntity<PayPalConnectAccessTokenData> response;
        try {
            response = restTemplate
                .postForEntity(endpointUrl, httpEntity, PayPalConnectAccessTokenData.class);
        } catch (Exception e) {
            LOG.error(ERROR_MESSAGE, e);
            throw new AdapterException(e.getMessage());
        }
        return response.getBody();
    }

    private String getAuthorizationHeaderValue() {
        String clientIdAndSecret = getDefaultPayPalConfigurationService().getClientID() + ":"
            + getDefaultPayPalConfigurationService().getSecretKey();
        return new String(Base64.getEncoder().encode(clientIdAndSecret.getBytes()));
    }

}
