package com.paypal.hybris.core.commands.impl;

import com.paypal.http.HttpResponse;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.request.PayPalAuthorizationRequest;
import com.paypal.orders.Authorization;
import com.paypal.orders.Order;
import com.paypal.orders.OrderActionRequest;
import com.paypal.orders.OrdersAuthorizeRequest;
import com.paypal.orders.PurchaseUnit;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.AuthorizationCommand;
import de.hybris.platform.payment.commands.request.AuthorizationRequest;
import de.hybris.platform.payment.commands.result.AuthorizationResult;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.math.BigDecimal;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.CREATED_STATUS_RESULT;


public class DefaultPayPalAuthorizationCommand extends PayPalAbstractCommand implements AuthorizationCommand {

    private static final String AUTHORIZATION_FAILURE_MESSAGE = "Authorization failed: ";

    private static final Logger LOG = Logger.getLogger(DefaultPayPalAuthorizationCommand.class);

    @Override
    public AuthorizationResult perform(AuthorizationRequest authorizationRequest) {
        final OrdersAuthorizeRequest ordersAuthorizeRequest = new OrdersAuthorizeRequest(
            ((PayPalAuthorizationRequest) authorizationRequest).getOrderNumber());
        ordersAuthorizeRequest.requestBody(new OrderActionRequest());
        HttpResponse<Order> response = null;
        final String id = ((PayPalAuthorizationRequest) authorizationRequest).getOrderNumber();
        try {
            response = createClient().execute(ordersAuthorizeRequest);
        } catch (IOException e) {
            final String message = "Exception, message : " + e.getMessage();
            LOG.error(message, e);
            LOG.error(AUTHORIZATION_FAILURE_MESSAGE);
            throw new AdapterException(getDescriptionFromPayPalErrorMessage(e.getMessage()));
        }
        return translateResponse(response, id);
    }

    private AuthorizationResult translateResponse(HttpResponse<Order> response, String id) {
        final AuthorizationResult authorizationResult = new AuthorizationResult();
        for (final PurchaseUnit purchaseUnit : response.result().purchaseUnits()) {
            if (purchaseUnit != null && id.equals(purchaseUnit.id())) {
                final Authorization createdAuthorization = getCreatedAuthorization(purchaseUnit);
                final BigDecimal createdAuthorizationAmount = createdAuthorization != null ?
                    new BigDecimal(createdAuthorization.amount().value()) : BigDecimal.ZERO;
                authorizationResult.setTotalAmount(createdAuthorizationAmount);
            }
        }
        return authorizationResult;
    }

    private Authorization getCreatedAuthorization(PurchaseUnit purchaseUnit) {
        for (final Authorization authorization : purchaseUnit.payments().authorizations()) {
            if (authorization != null && CREATED_STATUS_RESULT.equals(authorization.status())) {
                return authorization;
            }
        }
        return null;
    }

}
