package com.paypal.hybris.backoffice.action.order.voidorder;


import com.google.common.base.Predicate;
import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.actions.CockpitAction;
import com.hybris.cockpitng.engine.impl.AbstractComponentWidgetAdapterAware;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.ordercancel.OrderCancelService;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.servicelayer.user.UserService;
import org.apache.commons.collections.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

public class PayPalVoidOrderAction extends AbstractComponentWidgetAdapterAware implements
    CockpitAction<OrderModel, OrderModel> {

    protected static final String SOCKET_OUT_CONTEXT = "cancelOrderContext";
    protected static final String CAPTURE_PAYMENT_ON_CONSIGNMENT = "warehousing.capturepaymentonconsignment";
    protected static final String SUCCESS = "success";
    @Resource
    private UserService userService;
    @Resource
    private OrderCancelService orderCancelService;
    @Resource
    private List<OrderStatus> notCancellableOrderStatus;

    public PayPalVoidOrderAction() {
        //default constructor
    }

    public boolean canPerform(ActionContext<OrderModel> actionContext) {
        OrderModel order = actionContext.getData();
        if (order != null && !CollectionUtils.isEmpty(order.getEntries()) && this.getOrderCancelService()
            .isCancelPossible(order, this.getUserService().getCurrentUser(), Boolean.TRUE, Boolean.TRUE).isAllowed()
            && !this
            .getNotCancellableOrderStatus().contains(order.getStatus())) {
            return isCancelable(order);
        }
        return false;
    }

    public String getConfirmationMessage(ActionContext<OrderModel> actionContext) {
        return null;
    }


    public boolean needsConfirmation(ActionContext<OrderModel> actionContext) {
        return false;
    }

    public ActionResult<OrderModel> perform(ActionContext<OrderModel> actionContext) {
        this.sendOutput(SOCKET_OUT_CONTEXT, actionContext.getData());
        return new ActionResult(SUCCESS);
    }

    private boolean isCancelable(OrderModel order) {
        Predicate<PaymentTransactionEntryModel> captureEntries = entry -> (
            (PaymentTransactionType.PARTIAL_CAPTURE.equals(entry.getType())
                || PaymentTransactionType.CAPTURE.equals(entry.getType()))
                && TransactionStatus.ACCEPTED.name().equals(entry.getTransactionStatus()));

        Predicate<PaymentTransactionEntryModel> authorizationEntries = entry ->
            (PaymentTransactionType.AUTHORIZATION.equals(entry.getType()))
                && TransactionStatus.ACCEPTED.name().equals(entry.getTransactionStatus());

        boolean authorized = order.getPaymentTransactions().stream()
            .flatMap(transaction -> transaction.getEntries().stream())
            .anyMatch(authorizationEntries);
        boolean notCaptured = order.getPaymentTransactions().stream()
            .flatMap(transaction -> transaction.getEntries().stream())
            .noneMatch(captureEntries);
        return authorized && notCaptured;
    }

    protected OrderCancelService getOrderCancelService() {
        return this.orderCancelService;
    }

    protected UserService getUserService() {
        return this.userService;
    }

    protected List<OrderStatus> getNotCancellableOrderStatus() {
        return this.notCancellableOrderStatus;
    }
}

