package com.paypal.hybris.backoffice.action.order.refund;

import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.actions.CockpitAction;
import com.hybris.cockpitng.engine.impl.AbstractComponentWidgetAdapterAware;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.returns.ReturnService;

import javax.annotation.Resource;
import java.math.BigDecimal;


public class PayPalRefundAction extends AbstractComponentWidgetAdapterAware implements
    CockpitAction<OrderModel, OrderModel> {

    protected static final String SOCKET_OUT_CONTEXT = "paypalPartialRefundContext";
    private static final String SUCCESFULL = "SUCCESFULL";

    @Resource
    private ReturnService returnService;

    @Override
    public boolean canPerform(ActionContext<OrderModel> ctx) {
        final OrderModel order = ctx.getData();

        if (order == null) {
            return false;
        }

        BigDecimal capturedAmount = BigDecimal.ZERO;
        for (PaymentTransactionModel paymentTransaction : order.getPaymentTransactions()) {
            for (PaymentTransactionEntryModel transactionEntry : paymentTransaction.getEntries()) {
                if (SUCCESFULL.equals(transactionEntry.getTransactionStatusDetails()) &&
                    TransactionStatus.ACCEPTED.name().equals(transactionEntry.getTransactionStatus())) {
                    capturedAmount = addCapturedAmount(capturedAmount, transactionEntry);
                }
            }
        }
        return capturedAmount.compareTo(BigDecimal.ZERO) > 0 && !OrderStatus.CANCELLED.equals(order.getStatus());
    }

    public BigDecimal addCapturedAmount(BigDecimal capturedAmount, PaymentTransactionEntryModel transactionEntry) {
        PaymentTransactionType transactionType = transactionEntry.getType();
        if (PaymentTransactionType.CAPTURE.equals(transactionType) || PaymentTransactionType.PARTIAL_CAPTURE
            .equals(transactionType)) {
            capturedAmount = capturedAmount.add(transactionEntry.getAmount());
        } else if (PaymentTransactionType.REFUND_PARTIAL.equals(transactionType)) {
            capturedAmount = capturedAmount.subtract(transactionEntry.getAmount());
        }
        return capturedAmount;
    }

    @Override
    public ActionResult<OrderModel> perform(ActionContext<OrderModel> actionContext) {
        OrderModel order = actionContext.getData();
        sendOutput(SOCKET_OUT_CONTEXT, order);

        return new ActionResult<>(ActionResult.SUCCESS);
    }

    public ReturnService getReturnService() {
        return returnService;
    }

    public void setReturnService(ReturnService returnService) {
        this.returnService = returnService;
    }
}
