package com.paypal.hybris.backoffice.action.order.reauthorize;

import com.hybris.backoffice.widgets.notificationarea.NotificationService;
import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.actions.CockpitAction;
import com.hybris.cockpitng.engine.impl.AbstractComponentWidgetAdapterAware;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.processengine.BusinessProcessService;
import de.hybris.platform.servicelayer.model.ModelService;
import org.apache.log4j.Logger;

import javax.annotation.Resource;


public class PayPalReauthorizeAction extends AbstractComponentWidgetAdapterAware implements
    CockpitAction<OrderModel, OrderModel> {

    private static final Logger LOG = Logger.getLogger(PayPalReauthorizeAction.class);
    private static final String MANUAL_PAYMENT_REAUTH_EVENT = "ManualPaymentReauthEvent";
    private static final String SOCKET_OUT_CONTEXT = "paypalReauthorizeContext";
    @Resource
    private BusinessProcessService businessProcessService;
    @Resource
    private ModelService modelService;
    @Resource
    private NotificationService notificationService;

    public PayPalReauthorizeAction() {
        //default constructor
    }

    public ActionResult<OrderModel> perform(ActionContext<OrderModel> actionContext) {
        sendOutput(SOCKET_OUT_CONTEXT, actionContext.getData());

        ActionResult<OrderModel> actionResult = new ActionResult<>(ActionResult.SUCCESS);
        OrderModel order = (OrderModel) actionContext.getData();
        executeManualPaymentAuthOperation(order);
        return actionResult;
    }

    public boolean canPerform(ActionContext<OrderModel> ctx) {
        OrderModel order = (OrderModel) ctx.getData();
        return order != null && OrderStatus.PAYMENT_NOT_CAPTURED.equals(order.getStatus());
    }

    public boolean needsConfirmation(ActionContext<OrderModel> ctx) {
        return false;
    }

    public String getConfirmationMessage(ActionContext<OrderModel> ctx) {
        return null;
    }

    protected void executeManualPaymentAuthOperation(OrderModel order) {
        order.getOrderProcess().stream()
            .filter(process -> process.getCode().startsWith(order.getStore().getSubmitOrderProcessCode()))
            .forEach(filteredProcess ->
                this.getBusinessProcessService()
                    .triggerEvent(filteredProcess.getCode() + "_" + MANUAL_PAYMENT_REAUTH_EVENT));
        LOG.info(String.format("Payment Reauth Manual Release completed. %s triggered.", MANUAL_PAYMENT_REAUTH_EVENT));
    }

    protected BusinessProcessService getBusinessProcessService() {
        return this.businessProcessService;
    }

    protected ModelService getModelService() {
        return this.modelService;
    }

    protected NotificationService getNotificationService() {
        return this.notificationService;
    }
}
