package com.paypal.hybris.backoffice.action.order.authorize;

import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.actions.CockpitAction;
import com.hybris.cockpitng.engine.impl.AbstractComponentWidgetAdapterAware;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import org.apache.commons.lang.StringUtils;


public class PayPalAuthorizeOrderAction extends AbstractComponentWidgetAdapterAware implements
    CockpitAction<OrderModel, OrderModel> {

    private static final String SOCKET_OUT_CONTEXT = "paypalAuthorizeOrderContext";


    @Override
    public ActionResult<OrderModel> perform(ActionContext<OrderModel> actionContext) {
        OrderModel order = actionContext.getData();
        sendOutput(SOCKET_OUT_CONTEXT, order);
        return new ActionResult<>(ActionResult.SUCCESS);
    }

    @Override
    public boolean canPerform(ActionContext<OrderModel> ctx) {
        final OrderModel order = ctx.getData();
        boolean canPerform = false;
        if (order != null) {
            PaymentInfoModel paymentInfo = order.getPaymentInfo();
            if (!(paymentInfo instanceof PayPalCreditCardPaymentInfoModel)) {
                canPerform = false;
            } else {
                final String billingAgreementId = ((PayPalCreditCardPaymentInfoModel) paymentInfo)
                    .getBillingAgreementId();
                canPerform = StringUtils.isNotEmpty(billingAgreementId) && OrderStatus.PAYMENT_NOT_CAPTURED
                    .equals(order.getStatus());
            }
        }
        return canPerform;
    }


}
