/*

 */
package com.paypal.hybris.paypalb2bregistrationaddon.workflows.actions;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.b2b.model.B2BCustomerModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.secureportaladdon.model.B2BRegistrationModel;
import de.hybris.platform.secureportaladdon.workflows.actions.AbstractAutomatedWorkflowTemplateJob;
import de.hybris.platform.workflow.enums.WorkflowActionStatus;
import de.hybris.platform.workflow.exceptions.WorkflowTerminatedException;
import de.hybris.platform.workflow.model.WorkflowActionModel;
import de.hybris.platform.workflow.model.WorkflowDecisionModel;

import java.util.ArrayList;
import java.util.List;

public class PayPalRegistrationApprovedAutomatedWorkflowTemplateJob extends AbstractAutomatedWorkflowTemplateJob {

    @Override
    public WorkflowDecisionModel perform(WorkflowActionModel workflowAction) {
        final B2BRegistrationModel registration = getRegistrationAttachment(workflowAction);
        validateRegistrationUnit(registration);
        final CustomerModel customer = getCustomer(registration);

        final B2BCustomerModel b2BCustomer = createB2BCustomerModel(customer, registration);

        getModelService().save(b2BCustomer);

        return defaultDecision(workflowAction);
    }

    private void validateRegistrationUnit(B2BRegistrationModel registration) {
        if (registration.getDefaultB2BUnit() == null) {
            throw new WorkflowTerminatedException("Default B2B unit is null!");
        }
    }

    protected B2BCustomerModel createB2BCustomerModel(final CustomerModel customer, final B2BRegistrationModel registration) {

        final B2BCustomerModel b2bCustomer = getModelService().create(B2BCustomerModel.class);

        b2bCustomer.setEmail(customer.getUid());
        b2bCustomer.setName(customer.getName());
        b2bCustomer.setTitle(customer.getTitle());
        b2bCustomer.setUid(customer.getUid());
        b2bCustomer.setPayPalPayerId(customer.getPayPalPayerId());
        b2bCustomer.setDefaultB2BUnit(registration.getDefaultB2BUnit());

        final List<PaymentInfoModel> paymentInfoModels = new ArrayList<>(customer.getPaymentInfos());
        final List<PayPalCreditCardPaymentInfoModel> paymentInfoClones = new ArrayList<>();

        for (PaymentInfoModel paymentInfoModel : paymentInfoModels) {
            if (paymentInfoModel instanceof PayPalCreditCardPaymentInfoModel) {
                PayPalCreditCardPaymentInfoModel paymentInfoClone = getModelService()
                        .clone((PayPalCreditCardPaymentInfoModel) paymentInfoModel);
                paymentInfoClone.setUser(b2bCustomer);
                paymentInfoClones.add(paymentInfoClone);
            }
        }
        paymentInfoClones.stream().findFirst().ifPresent(b2bCustomer::setDefaultPaymentInfo);

        final List<AddressModel> addressModels = new ArrayList<>(customer.getAddresses());
        final List<AddressModel> addressClones = new ArrayList<>();

        for (AddressModel addressModel : addressModels) {
            AddressModel addressClone = getModelService().clone(addressModel);
            addressClone.setOwner(b2bCustomer);
            addressClones.add(addressClone);
        }
        addressClones.stream().findFirst().ifPresent(addressClone -> {
            b2bCustomer.setDefaultShipmentAddress(addressClone);
            b2bCustomer.setDefaultPaymentAddress(addressClone);
        });
        getModelService().remove(customer);

        paymentInfoClones.forEach(getModelService()::save);
        addressClones.forEach(getModelService()::save);

        return b2bCustomer;
    }
}
