<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="formElement" tagdir="/WEB-INF/tags/responsive/formElement" %>
<%@ taglib prefix="sptemplate" tagdir="/WEB-INF/tags/addons/b2bacceleratoraddon/responsive/secureportal/sptemplate" %>
<%@ taglib prefix="spuser" tagdir="/WEB-INF/tags/addons/b2bacceleratoraddon/responsive/secureportal/spuser" %>
<spring:url value="/" var="homeUrl"/>
<spring:theme code="paypal.button.render.error" var="buttonError"/>
<spring:theme code="wrong.sent.parameters" var="errorMessage"/>
<spring:theme code="error.on.paypal.side" var="paypalError"/>

<sptemplate:page pageTitle="${pageTitle}">
    <jsp:body>
        <div class="save-payment-info-container">
            <form:form method="POST"
                       action="${homeUrl}${savePaymentInfoUrl}">
                <p id="save-payment-info-text">
                    <spring:theme code="paypal.connect.registration.save.payment.info"/>
                </p>
                <div class="save-payment-info">
                    <div class="save-payment-info-form-action row">
                        <div id="paypalButton"></div>
                        <button data-theme="b" type="submit"
                                class="save-payment-info-button btn btn-primary btn-block"> Yes </button>
                        <button data-theme="b" type="submit"
                                class="save-payment-info-button btn btn-primary btn-block"> No </button>
                        <div id="errorMessage"><span></span></div>
                    </div>
                </div>

            </form:form>

            <form:form id="savePaymentInfo" method="POST" action="${homeUrl}${billingAgreementProcessUrl}">
            </form:form>

            <script>

              var currencyIso = "USD";
              var commit = false;
              var fundingSource;

              var MARK_BUTTON_CONTAINER = "#paypalButton";

              importPayPalSdk();

              renderBillingAgreementButton();

              function renderBillingAgreementButton() {
                var waitForSdk = setInterval(function () {
                  try{
                    if (typeof paypal !== "undefined") {
                      clearInterval(waitForSdk);
                      paypal.Buttons(
                          {
                            ${customJsConfig}

                            onClick: function (button) {
                              fundingSource = button.fundingSource;
                            },

                            createBillingAgreement: function () {
                              var createTokenUrl = "${homeUrl}" + "${createBillingAgreementTokenUrl}";
                              return fetch(createTokenUrl, {
                                method: 'get',
                                headers: {
                                  'content-type': 'application/json'
                                }
                              }).then(function (res) {
                                return res.json();
                              });
                            },
                            onApprove: function (data) {
                              var submitForm = $('#' + "savePaymentInfo");
                              var billingAgreementToken = createHiddenParameter("billingAgreementToken", data.billingToken);
                              var funding = createHiddenParameter("funding", fundingSource);
                              submitForm.append($(billingAgreementToken));
                              submitForm.append($(funding));
                              submitForm.submit();

                            },
                            onError: function (err) {
                              console.log(err);
                              handleError("${paypalError}");
                            }

                          }).render(MARK_BUTTON_CONTAINER);
                    }
                  }catch(err){
                    handleError("${buttonError}" + err.message);
                  }
                }, 10);
              }

              function importPayPalSdk() {
                var enableFunding = "";
                var disableFunding = "";
                var vault;
                var intent;
                var buyerCountry = "";
                var locale = "";
                if ("${payPalCheckoutData.configurationData.environmentType}" === "sandbox"){
                  buyerCountry = "&buyer-country=${payPalCheckoutData.configurationData.buyerCountry}";
                  locale = "&locale=en_US";
                }

                  vault = "true";
                  intent = "tokenize";

                if (${not empty payPalCheckoutData.configurationData.disableFunding}) {
                  disableFunding = "&disable-funding=${payPalCheckoutData.configurationData.disableFunding}";
                }
                var source = document.createElement("script");
                source.src = "${payPalCheckoutData.configurationData.payPalSdkUrl}client-id=${payPalCheckoutData.configurationData.client_id}" + enableFunding + "&commit=" + commit + disableFunding +
                    "&intent=" + intent + "&vault=" + vault + "&currency=" + currencyIso + buyerCountry + locale;
                document.body.appendChild(source);
                source.onerror = function() {
                  handleError("${buttonError}" + "${errorMessage}");
                };
              }

              function handleError(message){
                $("#errorMessage span").text(message);
              }

              function createHiddenParameter(name, value) {
                return $("<input>").attr("type", "hidden").attr("name", name).val(
                    value);
              }
            </script>
        </div>
    </jsp:body>
</sptemplate:page>
