<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sptemplate" tagdir="/WEB-INF/tags/addons/b2bacceleratoraddon/responsive/secureportal/sptemplate" %>
<%@ taglib prefix="spuser" tagdir="/WEB-INF/tags/addons/b2bacceleratoraddon/responsive/secureportal/spuser" %>

<spring:htmlEscape defaultHtmlEscape="true" />
<sptemplate:page pageTitle="${pageTitle}">
    <jsp:body>
        <div class="row">
            <div class="col-sm-offset-2 col-sm-8 col-md-offset-3 col-md-6">
                <div class="login-section">
                    <c:url value="/j_spring_security_check" var="loginActionUrl"/>
                    <spuser:login actionNameKey="login.login" action="${loginActionUrl}"/>

                    <c:if test="${isPayPalConnectEnabled}">

                        <div class="iframe-paypal-connect">
                            <span class="paypalConnectButton">
                                <div class="paypal-connect-button-container">
                                    <iframe
                                            srcdoc="
                                        <html>
                                            <body>
                                                <div class='paypal-connect-button' style='text-align:center'>
                                                    <span id='${containerID}'></span>
                                                </div>

                                                <script>

                                                    window.open = function (a, b, c, d) {
                                                        window.parent.location = a;
                                                    };

                                                    importPayPalSdk();
                                                    function importPayPalSdk() {
                                                        var body = document.body;
                                                        var script = document.createElement('script');
                                                        script.innerHTML = '';
                                                        script.src = '${payPalConnectScript}';
                                                        script.async = false;
                                                        script.defer = true;
                                                        script.onload = function() {
                                                            renderButton();
                                                        };
                                                        body.appendChild(script);
                                                    }

                                                    function renderButton() {
                                                        var authend = '';
                                                        if ('${environmentType}' === 'sandbox') {
                                                          authend = 'sandbox';
                                                        }
                                                        paypal.use(['login'], function (login) {
                                                          login.render({
                                                            'appid': '${clientID}',
                                                            'authend': authend,
                                                            'scopes': '${payPalConnectScopes}',
                                                            'containerid': '${containerID}',
                                                            'responseType': '${payPalConnectResponseType}',
                                                            'theme': '${theme}',
                                                            'buttonType': '${buttonType}',
                                                            'buttonShape': '${buttonShape}',
                                                            'buttonSize': '${buttonSize}',
                                                            'fullPage': '${fullPage}',
                                                            'returnurl': '${payPalConnectReturnUrl}',
                                                            'nonce': '12312312'
                                                          });
                                                        });
                                                    }

                                                </script>
                                            </body>
                                        </html>
                                    " title="Connect with PayPal login iframe" >
                                    </iframe>
                                </div>
                            </span>
                        </div>
                    </c:if>

                </div>
            </div>
        </div>
    </jsp:body>
</sptemplate:page>
