/*

 */
package com.paypal.hybris.paypalb2bregistration2205addon.controllers.pages;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ORDER_ID_PLACEHOLDER;
import static com.paypal.hybris.paypalb2bregistration2205addon.constants.Paypalb2bregistration2205addonWebConstants.CMS_REGISTER_PAGE_NAME;
import static com.paypal.hybris.paypalb2bregistration2205addon.constants.Paypalb2bregistration2205addonWebConstants.PAYPAL_CONNECT_AUTHORIZATION_CODE;
import static com.paypal.hybris.paypalb2bregistration2205addon.constants.Paypalb2bregistration2205addonWebConstants.PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN;
import static com.paypal.hybris.paypalb2bregistration2205addon.constants.Paypalb2bregistration2205addonWebConstants.Views;

import com.paypal.hybris.b2bfacade.PayPalB2BRegistrationUserFacade;
import com.paypal.hybris.core.service.PayPalConnectService;
import com.paypal.hybris.core.service.PayPalCustomerAccountService;
import com.paypal.hybris.data.PayPalBillingAgreementData;
import com.paypal.hybris.data.PayPalCheckoutData;
import com.paypal.hybris.data.PayPalConnectAddressData;
import com.paypal.hybris.data.PayPalConnectUserData;
import com.paypal.hybris.data.PayPalUserExistB2BData;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalRegistrationUserFacade;
import de.hybris.platform.acceleratorfacades.flow.CheckoutFlowFacade;
import de.hybris.platform.acceleratorstorefrontcommons.breadcrumb.Breadcrumb;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractLoginPageController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.acceleratorstorefrontcommons.forms.GuestForm;
import de.hybris.platform.acceleratorstorefrontcommons.forms.LoginForm;
import de.hybris.platform.acceleratorstorefrontcommons.forms.RegisterForm;
import de.hybris.platform.b2bacceleratoraddon.constants.B2bacceleratoraddonWebConstants;
import de.hybris.platform.b2bacceleratoraddon.forms.RegistrationForm;
import de.hybris.platform.b2bacceleratorfacades.exception.CustomerAlreadyExistsException;
import de.hybris.platform.b2bacceleratorfacades.exception.RegistrationNotEnabledException;
import de.hybris.platform.b2bacceleratorfacades.registration.B2BRegistrationFacade;
import de.hybris.platform.b2bcommercefacades.data.B2BRegistrationData;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.pages.AbstractPageModel;
import de.hybris.platform.cms2.model.pages.ContentPageModel;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.converters.Converters;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.util.localization.Localization;
import de.hybris.platform.yb2bacceleratorstorefront.controllers.ControllerConstants;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value = "paypal/connect/noauthentication")
public class PayPalConnectNoAuthenticationController extends AbstractLoginPageController {

    private static final Logger LOG = Logger.getLogger(PayPalConnectNoAuthenticationController.class);

    private static final String SCP_LINK_CREATE_ACCOUNT = "text.secureportal.link.createAccount";
    private static final String REGISTER_SUBMIT_CONFIRMATION = "paypal.connect.registration.request.created";
    private static final String REGISTER_REQUEST_NOR_APPROVED = "paypal.connect.registration.request.notApproved";
    private static final String REDIRECT_TO_CHECKOUT_PAGE = "/paypal/connect/noauthentication/register/checkout";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String PAYER_ID = "payerId";
    private static final String ADDRESS_DATA = "addressData";
    private static final String LOGIN_LABEL = "login";
    private static final String CHECKOUT_LOGIN_LABEL = "checkout-login";
    private static final String BREADCRUBMS = "breadcrumbs";
    private static final String PAYPAL_PAGE_INDICATOR = "isLoginPage";
    private static final String PAYPAL_CONNECT_GLOBAL_ERROR = "paypal.connect.registration.global.error";
    private static final String FUNDING_PARAMETER = "funding";
    private static final String CREATE_BILLING_AGREEMENT_TOKEN = "createBillingAgreementTokenUrl";
    private static final String CREATE_BILLING_AGREEMENT_TOKEN_URL = "paypal/connect/noauthentication/create-token";
    private static final String BILLING_AGREEMENT_PROCESS = "billingAgreementProcessUrl";
    private static final String BILLING_AGREEMENT_PROCESS_URL = "paypal/connect/noauthentication/response";
    private static final String SAVE_PAYMENT_INFO = "savePaymentInfoUrl";
    private static final String SAVE_PAYMENT_INFO_URL = "paypal/connect/noauthentication/savePaymentInfo";
    private static final String SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE = "/paypal/connect/noauthentication/savePaymentInfoAndAddressB2BPage";
    private static final String USER_IS_REGISTERED = "userIsRegistered";
    private static final String IS_PAYMENT_METHOD_SAVED = "isPaymentMethodSaved";
    private static final String IS_ADDRESS_SAVED = "isAddressSaved";
    private static final String REDIRECT_TO_NOAUTHENTICATION_REGISTER = "redirect:/paypal/connect/noauthentication/register";
    private static final String LOGIN_PAGE = "LOGIN";
    private static final String PAYPAL_CHECKOUT_DATA = "payPalCheckoutData";


    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "commonI18NService")
    private CommonI18NService commonI18NService;

    @Resource(name = "countryConverter")
    private Converter<CountryModel, CountryData> countryConverter;

    @Resource(name = "paypalConnectRegistrationValidator")
    private Validator registrationValidator;

    @Resource(name = "b2bRegistrationFacade")
    private B2BRegistrationFacade b2bRegistrationFacade;

    @Resource(name = "payPalConnectService")
    private PayPalConnectService payPalConnectService;

    @Resource(name = "payPalRegistrationUserFacade")
    private PayPalRegistrationUserFacade payPalRegistrationUserFacade;

    @Resource(name = "payPalCustomerAccountService")
    private PayPalCustomerAccountService payPalCustomerAccountService;

    @Resource(name = "payPalB2BRegistrationUserFacade")
    private PayPalB2BRegistrationUserFacade payPalB2BRegistrationUserFacade;

    @Resource(name = "checkoutFlowFacade")
    private CheckoutFlowFacade checkoutFlowFacade;

    @Resource(name = "sessionService")
    private SessionService sessionService;

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    @GetMapping(value = "/register")
    public String getRegister(final RegisterForm form, final HttpServletRequest request, final HttpServletResponse response,
        final HttpSession session, final Model model, @RequestParam(required = false) String code)
        throws CMSItemNotFoundException {
        sessionService.setAttribute(PAYPAL_PAGE_INDICATOR, true);
        printMessageAboutStatusPaymentMethodAndAddress(session, model);
        return getRegistrationFlow(form, request, response, session, model, code);
    }

    @PostMapping(value = "/register")
    public String doRegister(final RegistrationForm form, final BindingResult bindingResult,
        final HttpSession session, final Model model)
        throws CMSItemNotFoundException, CustomerAlreadyExistsException, RegistrationNotEnabledException {
        return doRegistrationFlow(form, bindingResult, session, model);
    }

    @GetMapping(value = "/register/checkout")
    public String getCheckoutRegister(final RegisterForm form, final HttpServletRequest request, final HttpServletResponse response,
        final HttpSession session, final Model model, @RequestParam(required = false) String code)
        throws CMSItemNotFoundException {
        sessionService.setAttribute(PAYPAL_PAGE_INDICATOR, false);
        model.addAttribute("expressCheckoutAllowed", checkoutFlowFacade.isExpressCheckoutEnabledForStore());
        return getRegistrationFlow(form, request, response, session, model, code);
    }

    @PostMapping(value = "/register/checkout")
    public String doCheckoutRegister(final RegistrationForm form, final BindingResult bindingResult,
        final HttpSession session, final Model model)
        throws CMSItemNotFoundException, CustomerAlreadyExistsException, RegistrationNotEnabledException {
        return doRegistrationFlow(form, bindingResult, session, model);
    }

    @PostMapping(value = "/savePaymentInfo")
    public String doSavePaymentInfo(final RegisterForm form, final BindingResult bindingResult, final HttpServletRequest request,
        final HttpServletResponse response,
        final HttpSession session, final Model model) throws CMSItemNotFoundException {
        populateModelCmsContent(model, getContentPageForLabelOrId(B2bacceleratoraddonWebConstants.CMS_REGISTER_PAGE_NAME));
        model.addAttribute(form);
        session.removeAttribute(ACCESS_TOKEN);
        return REDIRECT_TO_NOAUTHENTICATION_REGISTER;
    }

    @RequestMapping(value = "/create-token")
    public ResponseEntity<String> getBillingAgreementToken(final HttpServletRequest request,
        final HttpServletResponse response) {
        final boolean skipShipping = !checkoutFacade.hasNoDeliveryAddress();
        return ResponseEntity.ok(checkoutFacade.createBillingAgreementToken(skipShipping));
    }

    @PostMapping(value = "/response")
    public String doHandlePayPalResponse(final RegisterForm form, final HttpServletRequest request,
        final HttpServletResponse response, final HttpSession session, final Model model) throws CMSItemNotFoundException {

        final String billingAgreementToken = request.getParameter(PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN);
        final String paymentMethodType = request.getParameter(FUNDING_PARAMETER);
        final String payerId = (String) session.getAttribute(PAYER_ID);
        final PayPalConnectAddressData addressData = (PayPalConnectAddressData) session.getAttribute(ADDRESS_DATA);
        try {
            final PayPalBillingAgreementData billingAgreement = checkoutFacade
                .createBillingAgreement(billingAgreementToken);
            checkoutFacade
                .createPayPalPaymentSubscriptionForNewUser(billingAgreement, PAYPAL_ORDER_ID_PLACEHOLDER, paymentMethodType, payerId);
            session.setAttribute(IS_PAYMENT_METHOD_SAVED, true);
        } catch(Exception e) {
            LOG.error("Error during adding payment method for new customer", e);
            session.setAttribute(IS_PAYMENT_METHOD_SAVED, false);
        }
        try {
            if (addressData != null) {
                checkoutFacade.addAddressForNewUser(addressData, payerId);
                session.setAttribute(IS_ADDRESS_SAVED, true);
            }
        } catch(Exception e) {
            LOG.error("Error during adding address for new customer", e);
            session.setAttribute(IS_ADDRESS_SAVED, false);
        }
        session.removeAttribute(ACCESS_TOKEN);
        session.removeAttribute(ADDRESS_DATA);
        return REDIRECT_TO_NOAUTHENTICATION_REGISTER;
    }

    @Override
    protected AbstractPageModel getCmsPage() throws CMSItemNotFoundException {
        final boolean isLoginPage = sessionService.getAttribute(PAYPAL_PAGE_INDICATOR);
        if (isLoginPage) {
            return getContentPageForLabelOrId(LOGIN_LABEL);
        }
        return getContentPageForLabelOrId(CHECKOUT_LOGIN_LABEL);
    }

    @Override
    protected String getSuccessRedirect(HttpServletRequest request, HttpServletResponse response) {
        if (request.getServletPath().equals(REDIRECT_TO_CHECKOUT_PAGE)) {
            return getCheckoutRedirectUrl();
        }
        return REDIRECT_PREFIX + ROOT;
    }

    @Override
    protected String getView() {
        final boolean isLoginPage = sessionService.getAttribute(PAYPAL_PAGE_INDICATOR);
        sessionService.removeAttribute(PAYPAL_PAGE_INDICATOR);
        if (isLoginPage) {
            return ControllerConstants.Views.Pages.Account.AccountLoginPage;
        }
        return ControllerConstants.Views.Pages.Checkout.CheckoutLoginPage;
    }

    @Override
    protected String getCheckoutRedirectUrl() {
        if (getUserFacade().isAnonymousUser()) {
            return REDIRECT_TO_LOGIN_FOR_CHECKOUT;
        }
        return REDIRECT_TO_MULTISTEP_CHECKOUT;
    }

    private String getRegistrationFlow(final RegisterForm form, final HttpServletRequest request, final HttpServletResponse response,
        final HttpSession session, final Model model, final String code) throws CMSItemNotFoundException {
        if (code == null) {
            return getDefaultLoginPage(false, session, model);
        }
        String accessToken;
        try {
            if (session.getAttribute(ACCESS_TOKEN) == null) {
                accessToken = payPalConnectService
                        .exchangeAuthorizationCodeToAccessToken(request.getParameter(PAYPAL_CONNECT_AUTHORIZATION_CODE));
            } else {
                accessToken = (String) session.getAttribute(ACCESS_TOKEN);
            }
        } catch (AdapterException e) {
            LOG.error("Adapter exception", e);
            form.setTermsCheck(false);
            model.addAttribute(form);
            model.addAttribute(new LoginForm());
            model.addAttribute(new GuestForm());
            return handleRegistrationError(model);
        }
        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);
        final PayPalUserExistB2BData userExistB2BData =
            payPalB2BRegistrationUserFacade.isCustomerExistAndApprovedByPayerId(userData.getPayer_id());
        if (userExistB2BData.getIsExist() && userExistB2BData.getIsApproved()) {
            return processLogin(request, response, userData.getPayer_id());
        } else if (userExistB2BData.getIsExist()) {
            GlobalMessages.addInfoMessage(model, Localization.getLocalizedString(REGISTER_REQUEST_NOR_APPROVED));
            return getDefaultLoginPage(false, session, model);
        }
        session.setAttribute(ACCESS_TOKEN, accessToken);
        final List<CountryData> countries = Converters
            .convertAll(commonI18NService.getAllCountries(), countryConverter);
        model.addAttribute("titles", userFacade.getTitles());
        model.addAttribute("countries", countries);
        populateModelCmsContent(model,
            getContentPageForLabelOrId(CMS_REGISTER_PAGE_NAME));
        model.addAttribute(new RegistrationForm());
        return Views.PAYPAL_CONNECT_REGISTRATION_PAGE;
    }

    private String doRegistrationFlow(final RegistrationForm form, final BindingResult bindingResult,
        final HttpSession session, final Model model) throws CMSItemNotFoundException, RegistrationNotEnabledException {
        populateModelCmsContent(model,
            getContentPageForLabelOrId(CMS_REGISTER_PAGE_NAME));
        model.addAttribute(form);

        registrationValidator.validate(form, bindingResult);
        if (bindingResult.hasErrors()) {
            return Views.PAYPAL_CONNECT_REGISTRATION_PAGE;
        }

        final String accessToken = (String) session.getAttribute(ACCESS_TOKEN);
        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);

        session.setAttribute(PAYER_ID, userData.getPayer_id());
        session.setAttribute(ADDRESS_DATA, userData.getAddress());
        try {
            b2bRegistrationFacade.register(convertFormAndPayPalDataToRegistrationData(form, userData));
            payPalRegistrationUserFacade
                .setPayerIdToUser(userData.getEmails().get(0).getValue().toLowerCase(), userData.getPayer_id());
            session.setAttribute(USER_IS_REGISTERED, true);
        } catch (CustomerAlreadyExistsException e) {
            LOG.error("Failed to register account. Account already exists.", e);
            GlobalMessages.addErrorMessage(model, Localization.getLocalizedString(PAYPAL_CONNECT_GLOBAL_ERROR));
            return getRegistrationView();
        }
        return REDIRECT_PREFIX + SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE;
    }

    @GetMapping(value = "/savePaymentInfoAndAddressB2BPage")
    public String getSavePaymentInfoAndAddressB2BPage(final Model model, final HttpSession session) throws CMSItemNotFoundException {

        setModelAttributesForPaymentAndAddressInfo(model);

        storeCmsPageInModel(model, getCmsPage());
        setUpMetaDataForContentPage(model, (ContentPageModel) getCmsPage());

        if (session.getAttribute(USER_IS_REGISTERED) != null) {
            GlobalMessages.addInfoMessage(model, Localization.getLocalizedString(REGISTER_SUBMIT_CONFIRMATION));
        }
        session.removeAttribute(USER_IS_REGISTERED);

        return Views.PAYPAL_CONNECT_SAVE_PAYMENT_INFO_PAGE;
    }

    private B2BRegistrationData convertFormAndPayPalDataToRegistrationData(
        final RegistrationForm form, PayPalConnectUserData userData) {
        final B2BRegistrationData registrationData = new B2BRegistrationData();
        BeanUtils.copyProperties(form, registrationData);
        registrationData.setName(userData.getName());
        registrationData.setEmail(userData.getEmails().stream().findFirst().get().getValue().toLowerCase());
        return registrationData;
    }

    private void populateModelCmsContent(final Model model, final ContentPageModel contentPageModel) {

        storeCmsPageInModel(model, contentPageModel);
        setUpMetaDataForContentPage(model, contentPageModel);

        final Breadcrumb registrationBreadcrumbEntry = new Breadcrumb("#",
            getMessageSource().getMessage(SCP_LINK_CREATE_ACCOUNT, null, getI18nService().getCurrentLocale()), null);
        model.addAttribute(BREADCRUBMS, Collections.singletonList(registrationBreadcrumbEntry));
    }

    private String processLogin(final HttpServletRequest request, final HttpServletResponse response,
        final String payerId) {
        final CustomerData customer = payPalCustomerAccountService.getCustomerByPayerId(payerId);
        final String password = payPalCustomerAccountService.setTempPassword(payerId);
        this.getAutoLoginStrategy().login(customer.getUid(), password, request, response);
        payPalCustomerAccountService.clearTempPassword(payerId);
        return getSuccessRedirect(request, response);
    }

    protected CheckoutFlowFacade getCheckoutFlowFacade() {
        return checkoutFlowFacade;
    }

    private String getRegistrationView() {
        return B2bacceleratoraddonWebConstants.Views.REGISTRATION_PAGE;
    }

    private void printMessageAboutStatusPaymentMethodAndAddress(HttpSession session, Model model) {
        if (session.getAttribute(IS_PAYMENT_METHOD_SAVED) != null) {
            if ((boolean) session.getAttribute(IS_PAYMENT_METHOD_SAVED)) {
                GlobalMessages.addInfoMessage(model, "paypal.connect.saved.payment.method");
            } else {
                GlobalMessages.addErrorMessage(model, "paypal.connect.saved.payment.method.error");
            }
        }
        if (session.getAttribute(IS_ADDRESS_SAVED) != null) {
            if ((boolean) session.getAttribute(IS_ADDRESS_SAVED)) {
                GlobalMessages.addInfoMessage(model, "paypal.connect.saved.address");
            } else {
                GlobalMessages.addErrorMessage(model, "paypal.connect.saved.address.error");
            }
        }
        session.removeAttribute(IS_PAYMENT_METHOD_SAVED);
        session.removeAttribute(IS_ADDRESS_SAVED);
    }

    private void setModelAttributesForPaymentAndAddressInfo(Model model) {
        PayPalCheckoutData checkoutData = checkoutFacade.getPayPalCheckoutData(LOGIN_PAGE);
        model.addAttribute(PAYPAL_CHECKOUT_DATA, checkoutData);

        model.addAttribute(CREATE_BILLING_AGREEMENT_TOKEN, CREATE_BILLING_AGREEMENT_TOKEN_URL);
        model.addAttribute(BILLING_AGREEMENT_PROCESS, BILLING_AGREEMENT_PROCESS_URL);
        model.addAttribute(SAVE_PAYMENT_INFO, SAVE_PAYMENT_INFO_URL);
    }
}
