/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.paypal.hybris.paypalb2bregistration2205addon.constants;

/**
 * Global class for all Paypalb2bregistration2205addon web constants. You can add global constants for your extension into this class.
 */
public final class Paypalb2bregistration2205addonWebConstants 
{
	public static final String EXTENSIONNAME = "paypalb2bregistration2205addon";
	public static final String PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN = "billingAgreementToken";
	public static final String PAYPAL_CONNECT_AUTHORIZATION_CODE = "code";
	public static final String ADD_ON_PREFIX = "addon:";
	public static final String VIEW_PAGE_PREFIX = ADD_ON_PREFIX + "/" + Paypalb2bregistration2205addonConstants.EXTENSIONNAME;
	public static final String CMS_REGISTER_PAGE_NAME = "SecureCustomerPortalRegisterPage";
	private static final String REDIRECT_TO_LOGIN_PAGE = "addon:/b2bacceleratoraddon/pages/secureportal/login";
	private Paypalb2bregistration2205addonWebConstants()
	{
		//empty to avoid instantiating this constant class
	}

	// implement here constants used by this extension
	public static final class Views
	{
		public static final String PAYPAL_CONNECT_REGISTRATION_PAGE = VIEW_PAGE_PREFIX + "/pages/login/additionalData";
		public static final String PAYPAL_CONNECT_SAVE_PAYMENT_INFO_PAGE = VIEW_PAGE_PREFIX + "/pages/login/savePaymentInfo";

		private Views()
		{
		}
	}
}
