/**
 *
 */
package com.paypal.hybris.actions;

import com.paypal.hybris.core.service.PayPalCommerceCheckoutService;
import de.hybris.platform.b2bacceleratorservices.model.process.ReplenishmentProcessModel;
import de.hybris.platform.commerceservices.impersonation.ImpersonationContext;
import de.hybris.platform.commerceservices.impersonation.ImpersonationService;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.processengine.action.AbstractSimpleDecisionAction;
import de.hybris.platform.processengine.model.BusinessProcessParameterModel;
import org.springframework.beans.factory.annotation.Required;

public class PayPalAuthorizePaymentAction extends AbstractSimpleDecisionAction<ReplenishmentProcessModel>
{
    private PayPalCommerceCheckoutService commerceCheckoutService;
    private ImpersonationService impersonationService;

    @Override
    public Transition executeAction(final ReplenishmentProcessModel process) throws Exception
    {
        final BusinessProcessParameterModel clonedCartParameter = processParameterHelper.getProcessParameterByName(process, "cart");
        final CartModel clonedCart = (CartModel) clonedCartParameter.getValue();
        getModelService().refresh(clonedCart);

        final ImpersonationContext context = new ImpersonationContext();
        context.setOrder(clonedCart);
        return getImpersonationService().executeInContext(context,
                new ImpersonationService.Executor<Transition, ImpersonationService.Nothing>()
                {
                    @Override
                    public Transition execute()
                    {
                        if (clonedCart.getPaymentInfo() instanceof CreditCardPaymentInfoModel)
                        {
                            final PaymentTransactionEntryModel paymentTransactionEntryModel = getCommerceCheckoutService()
                                    .authorizePayment(clonedCart, null,
                                            getCommerceCheckoutService().getPaymentProvider(clonedCart));
                            if (paymentTransactionEntryModel == null
                                    || !TransactionStatus.ACCEPTED.name().equals(paymentTransactionEntryModel.getTransactionStatus()))
                            {
                                clonedCart.setStatus(OrderStatus.B2B_PROCESSING_ERROR);
                                modelService.save(clonedCart);
                                return Transition.NOK;
                            }
                        }
                        return Transition.OK;
                    }
                });
    }

    protected PayPalCommerceCheckoutService getCommerceCheckoutService()
    {
        return commerceCheckoutService;
    }

    @Required
    public void setCommerceCheckoutService(final PayPalCommerceCheckoutService commerceCheckoutService)
    {
        this.commerceCheckoutService = commerceCheckoutService;
    }

    protected ImpersonationService getImpersonationService()
    {
        return impersonationService;
    }

    @Required
    public void setImpersonationService(final ImpersonationService impersonationService)
    {
        this.impersonationService = impersonationService;
    }
}
