package com.paypal.hybris.b2baddon.renderer;


import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_CART_PAGE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MARK_PAGE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MINI_CART;

import com.paypal.hybris.facade.facades.impl.DefaultPayPalButtonRenderDecisionMakerFacade;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import de.hybris.platform.addonsupport.renderer.impl.DefaultAddOnCMSComponentRenderer;
import de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel;
import de.hybris.platform.spring.IgnoreTenantScopeMetadataResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import paypalhac.services.PayPalButtonConfigurationService;

import javax.annotation.Resource;
import javax.servlet.jsp.PageContext;
import java.util.Map;


@ComponentScan(basePackages = {
    "com.paypal.hybris.b2baddon.services"}, scopeResolver = IgnoreTenantScopeMetadataResolver.class)
public class PayPalB2bDefaultAddOnCMSComponentRenderer<C extends AbstractCMSComponentModel> extends
    DefaultAddOnCMSComponentRenderer<C> {

    private static final String CLIENT_ID = "clientId";
    private static final String INTENT = "intent";
    private static final String COMMIT = "commit";
    private static final String PAYPAL_SDK_URL = "paypalSDKUrl";
    private static final String DISABLE_FUNDING = "disableFunding";
    private static final String PAYPAL_BUTTON_COMPONENT = "PayPalButtonComponentB2B";
    private static final String PAYPAL_MINI_BUTTON_COMPONENT = "PayPalMiniButtonComponentB2B";
    private static final String PAYPAL_MARK_COMPONENT = "PayPalMarkComponentB2B";
    private static final String CUSTOM_JS_CONFIG = "customJsConfig";
    private static final String CART_BUTTON_CONFIG = "cart.button.config";
    private static final String MINI_CART_BUTTON_CONFIG = "mini.cart.button.config";
    private static final String MARK_BUTTON_CONFIG = "mark.button.config";
    private static final String PARTNER_ATTRIBUTION_ID = "partnerAttributionId";
    private static final String BUYER_COUNTRY = "buyerCountry";
    private static final String LOCALE = "locale";

    @Autowired
    private PayPalButtonConfigurationService payPalB2bButtonConfigurationService;

    @Resource(name = "payPalConfigurationService")
    private DefaultPayPalConfigurationService payPalConfigurationService;

    @Resource(name = "payPalButtonRenderDecisionMakerFacade")
    private DefaultPayPalButtonRenderDecisionMakerFacade payPalButtonRenderDecisionMakerFacade;

    protected Map<String, Object> exposeVariables(final PageContext pageContext,
        @SuppressWarnings("unused") final C component)
    {
        final Map<String, Object> variables = getVariablesToExpose(pageContext, component);
        if (variables != null) {
            for (final Map.Entry<String, Object> entry : variables.entrySet()) {
                pageContext.setAttribute(entry.getKey(), entry.getValue(), getScopeForVariableName(entry.getKey()));
            }

            pageContext.setAttribute(CLIENT_ID, payPalConfigurationService.getClientID(),
                getScopeForVariableName(CLIENT_ID));
            pageContext.setAttribute(INTENT, payPalConfigurationService.getPayPalIntent(),
                getScopeForVariableName(INTENT));
            pageContext.setAttribute(COMMIT, payPalConfigurationService.isCommitEnabled(),
                getScopeForVariableName(COMMIT));
            pageContext.setAttribute(PAYPAL_SDK_URL, payPalConfigurationService.getPayPalSdkJsUrl(),
                getScopeForVariableName(PAYPAL_SDK_URL));
            pageContext.setAttribute(PARTNER_ATTRIBUTION_ID, payPalConfigurationService.getPayPalPartnerAttributionId(),
                getScopeForVariableName(PARTNER_ATTRIBUTION_ID));

            String customJsConfig;

            switch (component.getUid()) {
                case PAYPAL_BUTTON_COMPONENT:
                    customJsConfig = payPalB2bButtonConfigurationService.getProperty(CART_BUTTON_CONFIG);
                    setPageContextForButtonComponent(PAYPAL_DISABLE_FUNDING_CART_PAGE, pageContext);
                    break;
                case PAYPAL_MINI_BUTTON_COMPONENT:
                    customJsConfig = payPalB2bButtonConfigurationService.getProperty(MINI_CART_BUTTON_CONFIG);
                    setPageContextForButtonComponent(PAYPAL_DISABLE_FUNDING_MINI_CART,pageContext);
                    break;
                case PAYPAL_MARK_COMPONENT:
                    customJsConfig = payPalB2bButtonConfigurationService.getProperty(MARK_BUTTON_CONFIG);
                    pageContext.setAttribute(DISABLE_FUNDING, payPalButtonRenderDecisionMakerFacade.getDisableFunding(PAYPAL_DISABLE_FUNDING_MARK_PAGE),
                        getScopeForVariableName(DISABLE_FUNDING));
                    // variables for testing
                    pageContext.setAttribute(BUYER_COUNTRY, payPalConfigurationService.getBuyerCountry(),
                        getScopeForVariableName(BUYER_COUNTRY));
                    pageContext.setAttribute(LOCALE, payPalConfigurationService.getLPMLocale(),
                        getScopeForVariableName(LOCALE));
                    break;
                default:
                    customJsConfig = "";
            }

            customJsConfig = "style: " + customJsConfig.replaceAll("[,{]", "$0 \n  ").replaceAll(":", "$0 ")
                .replaceAll("}", " \n$0");

            if (customJsConfig.length() > 0 && !customJsConfig.endsWith(",")) {
                customJsConfig += ",";
            }

            pageContext.setAttribute(CUSTOM_JS_CONFIG, customJsConfig, getScopeForVariableName(CUSTOM_JS_CONFIG));
        }
        return variables;
    }
    private void setPageContextForButtonComponent(final String disableFunding, final PageContext pageContext){
        pageContext.setAttribute(DISABLE_FUNDING, payPalButtonRenderDecisionMakerFacade.getDisableFunding(disableFunding),
            getScopeForVariableName(DISABLE_FUNDING));
        pageContext.setAttribute(BUYER_COUNTRY, payPalConfigurationService.getBuyerCountry(),
            getScopeForVariableName(BUYER_COUNTRY));

    }

}
