<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<spring:url value="/paypal/b2b/checkout/hop/response" var="markProcessUrl"/>
<spring:url value="/paypal/b2b/checkout/hop/create-order" var="createOrderUrl"/>
<spring:url value="/paypal/b2b/billing-agreement/checkout/response" var="billingAgreementProcessUrl"/>
<spring:url value="/paypal/b2b/billing-agreement/checkout/create-token" var="createBillingAgreementTokenUrl"/>
<spring:url value="/" var="homeUrl"/>
<spring:theme code="paypal.button.render.error" var="buttonError"/>
<spring:theme code="wrong.sent.parameters" var="errorMessage"/>
<spring:theme code="error.on.paypal.side" var="paypalError"/>


<label>
    <input id="paymentMethodPayPal" type="radio" name="paymentMethodSelection" value="paypal" checked/>
    <img src="${media.url}" alt="${media.altText}"/>
    <span id="whatIsPayPalLink" style="padding-left: 10px;"><cms:component component="${link}"/></span>
    <c:if test="${isBillingAgreementFlow}">
        <sec:authorize access="isFullyAuthenticated()">
            <div id="savePayPalPaymentInfo">
                <input type="checkbox" id="savePaymentInfoCheckbox"/>
                <label><spring:theme code="checkout.multi.sop.savePaymentInfo"/></label>
            </div>
        </sec:authorize>
    </c:if>
</label>
</br>
<label>
    <input id="paymentMethodCC" type="radio" name="paymentMethodSelection" value="cc"/>
    <label for="paymentMethodCC" id="creditCardLabelId" class="headline"><spring:theme
            code="checkout.multi.paymentMethod.addPaymentDetails.method.card"/></label>
</label>

<div id="paypal-sdk-src">

</div>

<script>
    var currencyIso = "${cartData.totalPrice.currencyIso}";
    var commit = "${commit}";
    var fundingSource;

    const MARK_BUTTON_CONTAINER = "#mark-paypal-button-container";

    importPayPalSdk();

    if (${isBillingAgreementFlow}) {
        renderBillingAgreementButton();
    } else {
        renderMarkButton();
    }

    function renderBillingAgreementButton() {
        var waitForSdk = setInterval(function () {
        try{
            if (typeof paypal !== "undefined") {
                clearInterval(waitForSdk);
                paypal.Buttons(
                    {
                        ${customJsConfig}

                        onClick: function (button) {
                            fundingSource = button.fundingSource;
                        },

                        createBillingAgreement: function () {
                            var createTokenUrl = "${createBillingAgreementTokenUrl}";
                            return fetch(createTokenUrl, {
                                method: 'get',
                                headers: {
                                    'content-type': 'application/json'
                                }
                            }).then(function (res) {
                                return res.json();
                            });
                        },
                        onApprove: function (data) {
                            var processUrl = "${billingAgreementProcessUrl}";
                            var params = {
                                "billingAgreementToken": data.billingToken,
                                "isSavePaymentInfo": $("#savePaymentInfoCheckbox").is(":checked"),
                                "isReplenishment": $("#isPayPalReplenishment").is(":checked"),
                                "funding": fundingSource
                            };
                            return $.post(processUrl, params).then(function (res) {
                                var url = "${homeUrl}" + res;
                                window.location.replace(url);
                            }).catch(function (err) {
                                handleError("${paypalError}");
                            });
                        },
                        onError: function (err) {
                            console.log(err)
                            handleError("${paypalError}");
                        }

                    }).render(MARK_BUTTON_CONTAINER);
            }
        }catch(err){
            handleError("${buttonError}" + err.message);
        }
        }, 10);
    }

    function renderMarkButton() {
        var waitForSdk = setInterval(function () {
        try{
            if (typeof paypal !== "undefined") {
                clearInterval(waitForSdk);
                paypal.Buttons(
                    {
                        ${customJsConfig}

                        onClick: function (button) {
                            fundingSource = button.fundingSource;
                        },

                        createOrder: function() {
                            var createOrderUrl = "${createOrderUrl}";
                            return $.post(createOrderUrl, {
                                funding: fundingSource
                            }).then(function (res) {
                                return res;
                            });
                        },
                        onApprove: function (data) {
                            var authorizeUrl = "${markProcessUrl}";
                            var params = {
                                "orderID": data.orderID,
                                "flow": "MARK_CHECKOUT",
                                "funding": fundingSource
                            };
                            return $.post(authorizeUrl, params)
                                .then(function (res) {
                                    var url = "${homeUrl}" + res;
                                    window.location.replace(url);
                                })
                                .catch(function (err) {
                                    handleError("${paypalError}");
                                });
                        },
                        onError: function (err) {
                            handleError("${paypalError}");
                        }
                    }).render(MARK_BUTTON_CONTAINER);
            }
        }catch(err){
            handleError("${buttonError}" + err.message);
        }
        }, 10);
    }

    function importPayPalSdk() {
        var enableFunding = "";
        var disableFunding = "";
        var vault = "false";
        var intent = "${intent}";
        var buyerCountry = "";
        var locale = "";
        if ("${environment}" === "sandbox"){
            buyerCountry = "&buyer-country=${buyerCountry}";
            locale = "&locale=${locale}";
        }
        if (${isBillingAgreementFlow}) {
            vault = "true";
            intent = "tokenize";
        }
        if (${not empty disableFunding}) {
            disableFunding = "&disable-funding=${disableFunding}";
        }
        if(${isVenmoEnabled}){
            enableFunding = "&enable-funding=venmo";
            if(${isPayLaterForNonUsCountriesEnabled}) {
            enableFunding += ",paylater";
            }
        } else if(${isPayLaterForNonUsCountriesEnabled}) {
            enableFunding = "&enable-funding=paylater";
        }
        var source = document.createElement("script");
        source.src = "${paypalSDKUrl}client-id=${clientId}" + enableFunding + "&commit=" + commit + disableFunding +
            "&intent=" + intent + "&vault=" + vault + "&currency=" + currencyIso + buyerCountry + locale;
        document.body.appendChild(source);
        source.onerror = function() {
            handleError("${buttonError}" + "${errorMessage}");
        };
    }

    function handleError(message){
        $("#errorMessage span").text(message);
    }
</script>
