<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:if test="${isCreditMessagesEnabled}">
    <script>
        var currencyIso = "${cartData.totalPrice.currencyIso}";
        if (!currencyIso || currencyIso.length === 0) {
            currencyIso = document.getElementsByName("cartCurrencyIso")[0].value;
        }
        var totalPrice = "${cartData.totalPriceWithTax.value}";
        var partnerAttributionId = "${partnerAttributionId}";

        function importPayPalSdk() {
            var enableFunding = "";
            if(${isVenmoEnabled}){
                enableFunding = "&enable-funding=venmo";
                if(${isPayLaterForNonUsCountriesEnabled}) {
                enableFunding += ",paylater";
                }
            } else if(${isPayLaterForNonUsCountriesEnabled}) {
                enableFunding = "&enable-funding=paylater";
            }

            var buyerCountry = "";
            if ("${environment}" === "sandbox") {
                buyerCountry = "&buyer-country=${buyerCountry}";
            }

            var disableFunding = "";
            var components = "";
            var vault = "false";
            var intent = "${intent}";
            var buyerCountry = "";
            if ("${environment}" === "sandbox") {
                buyerCountry = "&buyer-country=${buyerCountry}";
            }
            if (${isBillingAgreementFlow}) {
                vault = "true";
                intent = "tokenize";
            }
            if (${not empty disableFunding}) {
                disableFunding = "&disable-funding=${disableFunding}";
            }
            if (${not empty isCreditMessagesEnabled}) {
                components = "&components=buttons,messages"
            }
            var source = document.createElement("script");
            source.src = "${paypalSDKUrl}client-id=${clientID}" + enableFunding + "&commit=false" + disableFunding
                + "&intent=" + intent + "&vault=" + vault + "&currency=" + currencyIso + buyerCountry + components;
            source.setAttribute("data-partner-attribution-id", partnerAttributionId);
            document.body.appendChild(source);
        }

        if (typeof paypal === "undefined") {
            importPayPalSdk();
        }
    </script>

    <div id="paypal-credit-message"
         data-pp-message data-pp-placement="${component.placement.code}"
         data-pp-amount="${totalPrice.value}"
         data-pp-style-layout="${component.layout.code}"
         data-pp-style-color="${component.color}"
         data-pp-style-ratio="${component.ratio}"
         data-pp-style-logo-type="${component.logoType.code}"
         data-pp-style-logo-position="${component.logoPosition.code}"
         data-pp-style-text-color="${component.textColor.code}"
    ></div>

    <script>
        var target = document.getElementsByClassName("mini-cart-price")[0];
        var observer = new MutationObserver(function (mutations) {
            var totalPrice = target.innerHTML.trim().substr(1).replace(/,/g, '');
            document.getElementById("paypal-credit-message").setAttribute("data-pp-amount", totalPrice);
        });
        var config = {attributes: true, childList: true, characterData: true};
        observer.observe(target, config);
    </script>
</c:if>
