<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<div id="${buttonDiv}"></div>
<div id="errorMessage"><span></span></div>

<spring:url value="/paypal/b2b/checkout/hop/response" var="processUrl"/>
<spring:url value="/paypal/b2b/billing-agreement/checkout/create-token" var="createBillingAgreementTokenUrl"/>
<spring:url value="/paypal/b2b/billing-agreement/checkout/response" var="billingAgreementProcessUrl"/>
<spring:url value="/" var="homeUrl"/>
<spring:theme code="paypal.button.render.error" var="buttonError"/>
<spring:theme code="wrong.sent.parameters" var="errorMessage"/>
<spring:theme code="error.on.paypal.side" var="paypalError"/>

<sec:authorize var="loggedIn" access="isFullyAuthenticated()"/>

<script>
    var totalPrice = populateCartTotalPrice();
    var currencyIso = populateCartCurrencyIso();
    var partnerAttributionId = "${partnerAttributionId}";
    var fundingSource;
    var needReload = false;

    if (typeof paypal === "undefined") {
        importPayPalSdk();
    } else if(window.location.href.endsWith("/cart") || window.location.href.endsWith("/payment-method/add")) {
      delete window.paypal;
      importPayPalSdk();
      needReload = true;
    }

    if (${isBillingAgreementFlow}) {
        renderBillingAgreementButton(needReload);
    } else {
        renderButton(needReload);
    }

    function renderButton(needReload) {
        var waitForSdk = setInterval(function () {
            try {
                if (typeof paypal !== "undefined") {
                    clearInterval(waitForSdk);
                    paypal.Buttons(
                        {
                            ${customJsConfig}

                            onClick: function (button) {
                                fundingSource = button.fundingSource;
                            },
                            createOrder: function (data, actions) {
                                if (${loggedIn}) {
                                    return actions.order.create({
                                        purchase_units: [{
                                            amount: {
                                                value: totalPrice,
                                                currency_code: currencyIso
                                            }
                                        }]
                                    });
                                } else {
                                    var checkoutLoginUrl = "${homeUrl}" + "/login/checkout";
                                    window.location.replace(checkoutLoginUrl);
                                }
                            },
                            onApprove: function (data) {
                                var authorizeUrl = "${processUrl}";
                                var params = {
                                    "orderID": data.orderID,
                                    "flow": "EXPRESS_CHECKOUT",
                                    "funding": fundingSource
                                };
                                return $.post(authorizeUrl, params)
                                    .then(function (res) {
                                        var url = "${homeUrl}" + res;
                                        window.location.replace(url);
                                    })
                                    .catch(function (err) {
                                        handleError("${paypalError}");
                                    });
                            },
                            onError: function (err) {
                                handleError("${paypalError}");
                            },
                            onDestroy: function () {
                              if(needReload) {
                                location.reload();
                              }
                            }
                        }).render("#${buttonDiv}");
                }
            } catch (err) {
                handleError("${buttonError}" + err.message);
            }
        }, 10);
    }

    function renderBillingAgreementButton(needReload) {
        var waitForSdk = setInterval(function () {
            try {
                if (typeof paypal !== "undefined") {
                    clearInterval(waitForSdk);
                    var createTokenUrl = "${createBillingAgreementTokenUrl}";
                    paypal.Buttons(
                        {
                            ${customJsConfig}

                            onClick: function (button) {
                                fundingSource = button.fundingSource;
                            },

                            createBillingAgreement: function () {
                                return $.getJSON(createTokenUrl);
                            },
                            onApprove: function (data) {
                                var billingAgreementProcessUrl = "${billingAgreementProcessUrl}";
                                var params = {
                                    "billingAgreementToken": data.billingToken,
                                    "flow": "EXPRESS_BILLING_AGREEMENT_FLOW",
                                    "isSavePaymentInfo": "true",
                                    "funding": fundingSource
                                };
                                return $.post(billingAgreementProcessUrl, params)
                                    .then(function (res) {
                                        var url = "${homeUrl}" + res;
                                        window.location.replace(url);
                                    })
                                    .catch(function (err) {
                                        handleError("${paypalError}");
                                    });
                            },
                            onError: function (err) {
                                handleError("${paypalError}");
                            },
                            onDestroy: function () {
                              if(needReload) {
                                location.reload();
                              }
                            }
                        }).render("#${buttonDiv}");
                }

            } catch (err) {
                handleError("${buttonError}" + err.message);
            }
        }, 10);
    }

    function importPayPalSdk() {
        var enableFunding = "";
        if(${shouldVenmoDisplayed}){
            enableFunding = "&enable-funding=venmo";
            if(${isPayLaterForNonUsCountriesEnabled}) {
              enableFunding += ",paylater";
            }
        } else if(${isPayLaterForNonUsCountriesEnabled}) {
         enableFunding = "&enable-funding=paylater";
        }

        var buyerCountry = "";
        if ("${environment}" === "sandbox") {
            // TODO
            //change for real country
            buyerCountry = "&buyer-country=${buyerCountry}";
        }

        var disableFunding = "";
        var components = "";
        var vault = "false";
        var intent = "${intent}";
        var buyerCountry = "";
        if ("${environment}" === "sandbox") {
            buyerCountry = "&buyer-country=${buyerCountry}";
        }
        if (${isBillingAgreementFlow}) {
            vault = "true";
            intent = "tokenize";
        }
        if (${not empty disableFunding}) {
            disableFunding = "&disable-funding=${disableFunding}";
        }
        if (${not empty isCreditMessagesEnabled}) {
            components = "&components=buttons,messages"
        }
        var source = document.createElement("script");
        source.src = "${paypalSDKUrl}client-id=${clientId}" + enableFunding + "&commit=false" + disableFunding +
            "&intent=" + intent + "&vault=" + vault + "&currency=" + currencyIso + buyerCountry + components;
        source.setAttribute("data-partner-attribution-id", partnerAttributionId);
        document.body.appendChild(source);
        source.onerror = function () {
            handleError("${buttonError}" + "${errorMessage}");
        };
    }

    function handleError(message) {
        $("#errorMessage span").text(message);
    }

    function populateCartTotalPrice() {
      var totalPrice = "${cartData.totalPriceWithTax.value}";
      var nonDecimalCurrency = "${nonDecimalCurrency}";
      var currency = populateCartCurrencyIso();
      if (!totalPrice || totalPrice.length === 0) {
        totalPrice = document.getElementsByName("cartTotalPrice")[0].value;
      }
      if(nonDecimalCurrency.toLowerCase().includes(currency.toLowerCase())){
        totalPrice = Math.round(totalPrice);
      }
      return totalPrice;
    }

    function populateCartCurrencyIso() {
        var currencyIso = "${cartData.totalPrice.currencyIso}";
        if (!currencyIso || currencyIso.length === 0) {
            currencyIso = document.getElementsByName("cartCurrencyIso")[0].value;
        }
        return currencyIso;
    }
</script>
