/*

 */
package com.paypal.hybris.b2baddon.interceptors;

import de.hybris.platform.acceleratorstorefrontcommons.interceptors.BeforeViewHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class PayPalConnectBeforeViewHandler implements BeforeViewHandler {

    private static final String SECURE_PORTAL_VIEW_NAME = "addon:/secureportaladdon/pages/login";
    private static final String CONNECT_WITH_PAYPAL_VIEW_NAME = "addon:/paypalb2bregistrationaddon/pages/login/connectWithPayPalLogin";
    private static final String B2B_ACCELERATOR_ADDON_VIEW_NAME = "addon:/b2bacceleratoraddon/pages/secureportal/login";
    private static final String CONNECT_WITH_PAYPAL_2205_VIEW_NAME = "addon:/paypalb2bregistration2205addon/pages/login/connectWithPayPalLogin";

    @Override
    public void beforeView(HttpServletRequest request, HttpServletResponse response, ModelAndView modelAndView) throws Exception {
        if(modelAndView.getViewName().contentEquals(SECURE_PORTAL_VIEW_NAME)){
            modelAndView.setViewName(CONNECT_WITH_PAYPAL_VIEW_NAME);
        } else if (modelAndView.getViewName().contentEquals(B2B_ACCELERATOR_ADDON_VIEW_NAME)) {
            modelAndView.setViewName(CONNECT_WITH_PAYPAL_2205_VIEW_NAME);
        }
    }
}
