package com.paypal.hybris.b2baddon.controllers.pages;

import de.hybris.platform.acceleratorstorefrontcommons.annotations.PreValidateQuoteCheckoutStep;
import de.hybris.platform.acceleratorstorefrontcommons.annotations.RequireHardLogIn;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.b2bacceleratoraddon.controllers.pages.checkout.steps.SummaryCheckoutStepController;
import de.hybris.platform.b2bacceleratoraddon.forms.PlaceOrderForm;
import de.hybris.platform.b2bacceleratorfacades.checkout.data.PlaceOrderData;
import de.hybris.platform.b2bacceleratorfacades.exception.EntityValidationException;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.commercefacades.order.data.AbstractOrderData;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commerceservices.order.CommerceCartModificationException;
import de.hybris.platform.payment.AdapterException;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;


@Controller
@RequestMapping(value = "/paypal/checkout/multi/summary/")
public class PayPalSummaryCheckoutStepController extends SummaryCheckoutStepController {

    private static final Logger LOG = Logger.getLogger(PayPalSummaryCheckoutStepController.class);
    private static final String CHECKOUT_AUTHORIZATION_FAIL = "checkout.error.authorization.failed";
    private static final String CHECKOUT_PLACE_ORDER_FAIL = "checkout.placeOrder.failed";
    private static final String CHECKOUT_DELIVERY_ADDRESS_NOT_SELECTED = "checkout.deliveryAddress.notSelected";
    private static final String CHECKOUT_DELIVERY_METHOD_NOT_SELECTED = "checkout.deliveryMethod.notSelected";
    private static final String CHECKOUT_PAYMENT_METHOD_NOT_SELECTED = "checkout.paymentMethod.notSelected";
    private static final String CHECKOUT_TAX_MISSING = "checkout.error.tax.missing";
    private static final String CHECKOUT_CART_NOT_CALCULATED = "checkout.error.cart.notcalculated";

    @RequestMapping(value = "/placeOrder")
    @PreValidateQuoteCheckoutStep
    @RequireHardLogIn
    public String placeOrder(@ModelAttribute("placeOrderForm") final PlaceOrderForm placeOrderForm, final Model model,
        final RedirectAttributes redirectModel)
        throws CMSItemNotFoundException, CommerceCartModificationException {
        if (validateOrderForm(model)) {
            return enterStep(model, redirectModel);
        }
        boolean isPaymentAuthorized = false;
        try {
            isPaymentAuthorized = getCheckoutFacade().authorizePayment(null);
        } catch (final AdapterException ae) {
            LOG.error(ae.getMessage(), ae);
        }
        if (!isPaymentAuthorized) {
            GlobalMessages.addErrorMessage(model, CHECKOUT_AUTHORIZATION_FAIL);
            return enterStep(model, redirectModel);
        }

        final PlaceOrderData placeOrderData = new PlaceOrderData();
        final AbstractOrderData orderData;
        try {
            orderData = getB2BCheckoutFacade().placeOrder(placeOrderData);
        } catch (final EntityValidationException e) {
            LOG.error("Failed to place Order", e);
            GlobalMessages.addErrorMessage(model, e.getLocalizedMessage());

            placeOrderForm.setTermsCheck(false);
            model.addAttribute(placeOrderForm);

            return enterStep(model, redirectModel);
        } catch (final Exception e) {
            LOG.error("Failed to place Order", e);
            GlobalMessages.addErrorMessage(model, CHECKOUT_PLACE_ORDER_FAIL);
            return enterStep(model, redirectModel);
        }

        return redirectToOrderConfirmationPage(placeOrderData, orderData);
    }

    protected boolean validateOrderForm(final Model model) {
        boolean invalid = false;
        if (getCheckoutFlowFacade().hasNoDeliveryAddress()) {
            GlobalMessages.addErrorMessage(model, CHECKOUT_DELIVERY_ADDRESS_NOT_SELECTED);
            invalid = true;
        }
        if (getCheckoutFlowFacade().hasNoDeliveryMode()) {
            GlobalMessages.addErrorMessage(model, CHECKOUT_DELIVERY_METHOD_NOT_SELECTED);
            invalid = true;
        }
        if (getCheckoutFlowFacade().hasNoPaymentInfo()) {
            GlobalMessages.addErrorMessage(model, CHECKOUT_PAYMENT_METHOD_NOT_SELECTED);
            invalid = true;
        }
        final CartData cartData = getCheckoutFacade().getCheckoutCart();
        if (!getCheckoutFacade().containsTaxValues()) {
            LOG.error(String.format(
                "Cart %s does not have any tax values, which means the tax cacluation was not properly done, placement of order can't continue",
                cartData.getCode()));
            GlobalMessages.addErrorMessage(model, CHECKOUT_TAX_MISSING);
            invalid = true;
        }
        if (!cartData.isCalculated()) {
            LOG.error(
                String.format("Cart %s has a calculated flag of FALSE, placement of order can't continue",
                    cartData.getCode()));
            GlobalMessages.addErrorMessage(model, CHECKOUT_CART_NOT_CALCULATED);
            invalid = true;
        }
        return invalid;
    }
}
