package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.annotations.RequireHardLogIn;
import de.hybris.platform.yb2bacceleratorstorefront.controllers.pages.checkout.steps.PaymentMethodCheckoutStepController;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ORDER_ID_PLACEHOLDER;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE;


@Controller
@RequestMapping(value = "/paypal/checkout/multi/payment-method")
public class PayPalPaymentMethodCheckoutStepController extends PaymentMethodCheckoutStepController {

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade payPalCheckoutFacade;

    @RequestMapping(value = "/paypal/choose", method = RequestMethod.GET)
    @RequireHardLogIn
    public String doSelectPayPalPaymentMethod(
        @RequestParam("selectedPaymentMethodId") final String selectedPaymentMethodId,
        @RequestParam("isCheckedForReplenishment") final String isCheckedForReplenishment) {
        if (StringUtils.isNotBlank(selectedPaymentMethodId)) {
            payPalCheckoutFacade.setPaymentDetails(selectedPaymentMethodId);
            payPalCheckoutFacade.updateCheckoutPaymentInfoOrderId(PAYPAL_ORDER_ID_PLACEHOLDER);
        }
        getSessionService()
            .setAttribute(PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE, Boolean.valueOf(isCheckedForReplenishment));
        return getCheckoutStep().nextStep();
    }
}
