package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.b2bfacade.PayPalB2BCheckoutFacade;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractPageController;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.core.enums.CreditCardType;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CHECKOUT_MULTI_CONFIRMATION_PAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.EXPRESS_CHECKOUT;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.MARK_CHECKOUT;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYPAL_CHECKOUT_MULTI_SUMMARY_PLACE_ORDER;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYPAL_FLOW_OPTION;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYPAL_FUNDING;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAY_PAL_REQUEST_ORDER_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE;


@Controller
@RequestMapping(value = "/paypal/b2b/checkout/hop")
public class PayPalHopPaymentResponseController extends AbstractPageController {

    private static final String REDIRECT_TO_MULTISTEP_CHECKOUT_CONFIRMATION =
        REDIRECT_PREFIX + CHECKOUT_MULTI_CONFIRMATION_PAGE;

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    @Resource(name = "defaultPayPalB2BCheckoutFacade")
    private PayPalB2BCheckoutFacade b2BCheckoutFacade;

    /*
     * (non-Javadoc)
     *
     * @see
     * de.hybris.platform.storefront.controllers.pages.checkout.steps.HopPaymentResponseController#doHandleHopResponse
     * (javax.servlet.http.HttpServletRequest)
     */
    @RequestMapping(value = "/response")
    public ResponseEntity<String> doHandleHopResponse(final HttpServletRequest request,
        final HttpServletResponse response) {
        final String orderId = request.getParameter(PAY_PAL_REQUEST_ORDER_ID);
        final String checkoutType = request.getParameter(PAYPAL_FLOW_OPTION);
        final String fundingSource = request.getParameter(PAYPAL_FUNDING);
        getSessionService().removeAttribute(PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE);
        final PayPalOrderDetailsData orderDetailsData = checkoutFacade.getPayPalOrderDetails(orderId);
        if (StringUtils.equals(EXPRESS_CHECKOUT, checkoutType)) {
            b2BCheckoutFacade.setCardPaymentType();
            checkoutFacade.processExpressCheckout(orderDetailsData, fundingSource);
        } else if (StringUtils.equals(MARK_CHECKOUT, checkoutType)) {
            final CCPaymentInfoData payPalPaymentSubscription = checkoutFacade
                .updatePayPalPaymentSubscription(orderDetailsData, checkoutFacade.getCheckoutCart().getPaymentInfo());
            checkoutFacade.setPaymentDetails(payPalPaymentSubscription.getId());
        }
        return ResponseEntity.ok(getPayPalCheckoutResponseUrl());
    }

    @RequestMapping(value = "/create-order", method = RequestMethod.POST)
    public ResponseEntity<String> createOrderResponse(final HttpServletRequest request) {
        final String orderID = checkoutFacade.createPayPalOrder();
        final String fundingSource = request.getParameter(PAYPAL_FUNDING);
        final CreditCardType paymentType = checkoutFacade.setCreditCardType(fundingSource);
        final CCPaymentInfoData payPalPaymentSubscription = checkoutFacade
            .createPayPalPaymentSubscriptionForMarkCheckout(orderID, paymentType);
        checkoutFacade.setPaymentDetails(payPalPaymentSubscription.getId());
        return ResponseEntity.ok(orderID);
    }

    @Override
    protected String getCheckoutRedirectUrl() {
        if (getUserFacade().isAnonymousUser()) {
            return REDIRECT_TO_LOGIN_FOR_CHECKOUT;
        }
        return REDIRECT_TO_MULTISTEP_CHECKOUT_CONFIRMATION;
    }

    private boolean isReadyForConfirmation() {
        return !checkoutFacade.hasNoDeliveryAddress() && !checkoutFacade.hasNoPaymentInfo() && !checkoutFacade
            .hasNoDeliveryMode();
    }

    private String getPayPalCheckoutResponseUrl() {
        String responseUrl = CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS;
        if (checkoutFacade.isLocalPaymentFlow()) {
            responseUrl = PAYPAL_CHECKOUT_MULTI_SUMMARY_PLACE_ORDER;
        } else if (isReadyForConfirmation()) {
            responseUrl = CHECKOUT_MULTI_CONFIRMATION_PAGE;
        }
        return responseUrl;
    }
}
