package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants;
import com.paypal.hybris.b2baddon.model.PayPalConnectButtonComponentB2BModel;
import com.paypal.hybris.b2baddon.model.PayPalCreditMessageComponentB2BModel;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalButtonRenderDecisionMakerFacade;
import de.hybris.platform.addonsupport.interceptors.BeforeViewHandlerAdaptee;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.servicelayer.session.SessionService;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.ui.ModelMap;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.IS_ANONYMOUS_USER;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYMENT_INFOS;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE;


public class PayPalBeforeViewHandler implements BeforeViewHandlerAdaptee {

    private static final String ADDON_PREFIX_B2B = "addon:/b2bacceleratoraddon/";
    private static final String B2B_ADD_TO_CART_POPUP_PAGE = "fragments/cart/addToCartPopup";
    private static final String B2B_SILENT_ORDER_POST_PAGE = "pages/checkout/multi/silentOrderPostPage";
    private static final String B2B_CHECKOUT_SUMMARY_PAGE =
        ADDON_PREFIX_B2B + "pages/checkout/multi/checkoutSummaryPage";
    private static final String B2B_CHECKOUT_CONFIRMATION_PAGE =
        ADDON_PREFIX_B2B + "pages/checkout/checkoutConfirmationPage";
    private static final String B2B_CART_PAGE = "pages/cart/cartPage";
    private static final String ACCOUNT_LAYOUT_PAGE = "pages/account/accountLayoutPage";
    private static final String SECURE_PORTAL_VIEW_NAME = "addon:/secureportaladdon/pages/login";
    private static final String B2B_ACCELERATOR_ADDON_VIEW_NAME = "addon:/b2bacceleratoraddon/pages/secureportal/login";
    private static final String EXPRESS_CHECKOUT_COMPONENT = "expressCheckoutComponent";
    private static final String BILLING_AGREEMENT_POSSIBLE = "isBillingAgreementFlow";
    private static final String BILLING_AGREEMENT = "isBillingAgreement";
    private static final String IS_REPLENISHMENT_AVAILABLE = "isReplenishmentAvailable";
    private static final String IS_PLACE_ORDER_AVAILABLE = "isPlaceOrderAvailable";
    private static final String CART_DATA_TOTAL_PRICE = "cartDataTotalPrice";
    private static final String PAYAPAL_CART_PAGE_CREDIT_MESSAGE_COMPONENT_B2B = "PayPalCartPageCreditMessageComponentB2B";
    private static final String CREDIT_MESSAGE_COMPONENT = "creditMessageComponent";
    private static final String IS_CREDIT_MESSAGE_ENABLED = "isCreditMessagesEnabled";
    private static final String PAYPAL_BUTTON_COMPONENT_B2B = "PayPalButtonComponentB2B";
    private static final String PAYPAL_MINI_BUTTON_COMPONENT_B2B = "PayPalMiniButtonComponentB2B";
    private static final String PAYPAL_BILLING_AGREEMENT_EXPRESS_CHECKOUT = "PayPalBillingAgreementExpressCheckout";
    private static final String PAYPAL_CREDIT_CARD_REPLENISHMENT_AVAILABLE = "isCreditCardReplenishment";
    private static final String PAYPAL_ENVIRONMENT_TYPE = "environment";
    private static final String BUYER_COUNTRY = "buyerCountry";
    private static final String IS_VENMO_ENABLED = "isVenmoEnabled";
    private static final String IS_PAYLATER_ENABLED_FOR_NON_US_COUNTRIES = "isPayLaterForNonUsCountriesEnabled";
    private static final String NON_DECIMAL_CURRENCY = "nonDecimalCurrency";
    private static final String PAYPAL_EXPRESS_CHECKOUT_ENABLED = "isExpressCheckoutEnabled";
    private static final String PAYAPAL_CONNECT_BUTTON_COMPONENT_B2B = "PayPalConnectButtonComponentB2B";
    private static final String PAYPAL_CONNECT_COMPONENT = "payPalConnectComponent";
    private static final String CONTAINER_ID = "containerID";
    private static final String THEME = "theme";
    private static final String BUTTON_TYPE = "buttonType";
    private static final String BUTTON_SHAPE = "buttonShape";
    private static final String BUTTON_SIZE = "buttonSize";
    private static final String FULL_PAGE = "fullPage";
    private static final String PAYPAL_CONNECT_SCRIPT = "payPalConnectScript";
    private static final String PAYPAL_CONNECT_SCOPES = "payPalConnectScopes";
    private static final String PAYPAL_CONNECT_RESPONSE_TYPE = "payPalConnectResponseType";
    private static final String PAYPAL_CONNECT_RETURN_URL = "payPalConnectReturnUrl";
    private static final String PAYPAL_ENV_CONFIGURATION = "environmentType";
    private static final String CLIENT_ID = "clientID";
    private static final String IS_PAYPAL_CONNECT_ENABLED = "isPayPalConnectEnabled";
    private static final String SHOULD_VENMO_DISPLAYED ="shouldVenmoDisplayed";

    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    @Resource(name = "sessionService")
    private SessionService sessionService;

    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "payPalButtonRenderDecisionMakerFacade")
    private DefaultPayPalButtonRenderDecisionMakerFacade decisionMakerFacade;

    @Resource(name = "payPalConfigurationService")
    private DefaultPayPalConfigurationService payPalConfigurationService;

    @Override
    public String beforeView(HttpServletRequest request, HttpServletResponse response, ModelMap model, String viewName)
        throws Exception {

        model.addAttribute(IS_VENMO_ENABLED, payPalConfigurationService.isVenmoEnabled());
        model.addAttribute(IS_PAYLATER_ENABLED_FOR_NON_US_COUNTRIES,
            payPalConfigurationService.isPayLaterEnabledForNonUsCountries());
        model.addAttribute(PAYPAL_ENVIRONMENT_TYPE, payPalConfigurationService.getEnvironmentType());
        model.addAttribute(BUYER_COUNTRY, payPalConfigurationService.getBuyerCountry());
        model.addAttribute(SHOULD_VENMO_DISPLAYED,
                payPalConfigurationService.isVenmoEnabled() && !payPalConfigurationService.isBillingAgreementEnabled());

        if (B2B_SILENT_ORDER_POST_PAGE.equals(viewName)) {
            final List<CCPaymentInfoData> ccPaymentInfos = userFacade.getCCPaymentInfos(true);
            model.addAttribute(PAYMENT_INFOS, ccPaymentInfos);
            model.addAttribute(IS_REPLENISHMENT_AVAILABLE, payPalConfigurationService.isReplenishmentAvailable());
            model.addAttribute(BILLING_AGREEMENT_POSSIBLE, decisionMakerFacade.isMarkCheckoutBillingAgreementFlow());
            model.addAttribute(BILLING_AGREEMENT, payPalConfigurationService.isBillingAgreementEnabled());
            return Paypalb2baddonControllerConstants.Views.Pages.MultiStepCheckout.SILENT_ORDER_POST_PAGE;
        } else if (B2B_CHECKOUT_SUMMARY_PAGE.equals(viewName)) {
            final boolean isReplenishment = isReplenishmentEnabled(request);
            request.getSession().removeAttribute(PAYPAL_CREDIT_CARD_REPLENISHMENT_AVAILABLE);
            model.addAttribute(IS_REPLENISHMENT_AVAILABLE, isReplenishment);
            model.addAttribute(IS_PLACE_ORDER_AVAILABLE, !isReplenishment);
            return Paypalb2baddonControllerConstants.Views.Pages.MultiStepCheckout.CHECKOUT_SUMMARY_PAGE;
        } else if (B2B_CHECKOUT_CONFIRMATION_PAGE.equals(viewName)) {
            return Paypalb2baddonControllerConstants.Views.Pages.Checkout.CHECKOUT_CONFIRMATION_PAGE;
        } else if (B2B_ADD_TO_CART_POPUP_PAGE.equals(viewName)) {
            addExpressCheckoutComponent(model, viewName);
            model.addAttribute(CART_DATA_TOTAL_PRICE, cartFacade.getMiniCart().getTotalPrice());
            model.addAttribute(NON_DECIMAL_CURRENCY, payPalConfigurationService.getNonDecimalCurrency());
            model.addAttribute(IS_ANONYMOUS_USER, userFacade.isAnonymousUser());
            return Paypalb2baddonControllerConstants.Views.Fragments.Cart.ADD_TO_CART_POPUP;
        } else if (B2B_CART_PAGE.equals(viewName)) {
            addExpressCheckoutComponent(model, viewName);
            final PayPalCreditMessageComponentB2BModel creditMessageComponent = cmsComponentService
                .getSimpleCMSComponent(PAYAPAL_CART_PAGE_CREDIT_MESSAGE_COMPONENT_B2B);
            model.addAttribute(CREDIT_MESSAGE_COMPONENT, creditMessageComponent);
            model.addAttribute(IS_ANONYMOUS_USER, userFacade.isAnonymousUser());
            model.addAttribute(IS_CREDIT_MESSAGE_ENABLED,
                creditMessageComponent.getEnabled() && !payPalConfigurationService.isBillingAgreementEnabled());
        } else if (ACCOUNT_LAYOUT_PAGE.equals(viewName)) {
            model.addAttribute(BILLING_AGREEMENT_POSSIBLE, payPalConfigurationService.isBillingAgreementEnabled());
            return ACCOUNT_LAYOUT_PAGE;
        } else if (SECURE_PORTAL_VIEW_NAME.equals(viewName) || B2B_ACCELERATOR_ADDON_VIEW_NAME.equals(viewName)) {
            addPayPalConnectComponent(model);
        }
        model.addAttribute(NON_DECIMAL_CURRENCY, payPalConfigurationService.getNonDecimalCurrency());
        return viewName;
    }

    private void addExpressCheckoutComponent(final ModelMap model, final String viewName)
        throws CMSItemNotFoundException {
        final String buttonComponentName = B2B_CART_PAGE.equalsIgnoreCase(viewName) ? PAYPAL_BUTTON_COMPONENT_B2B
            : PAYPAL_MINI_BUTTON_COMPONENT_B2B;
        final SimpleCMSComponentModel payPalMiniButtonComponent = cmsComponentService
            .getSimpleCMSComponent(buttonComponentName);
        final SimpleCMSComponentModel payPalExpressCheckoutComponent = cmsComponentService
            .getSimpleCMSComponent(PAYPAL_BILLING_AGREEMENT_EXPRESS_CHECKOUT);
        model.addAttribute(EXPRESS_CHECKOUT_COMPONENT,
            decisionMakerFacade.isExpressCheckoutStaticImageFlow(cartFacade.getSessionCart()) ?
                payPalExpressCheckoutComponent : payPalMiniButtonComponent);
        model.addAttribute(BILLING_AGREEMENT_POSSIBLE, decisionMakerFacade.isExpressCheckoutBillingAgreementFlow());
        model.addAttribute(PAYPAL_EXPRESS_CHECKOUT_ENABLED, payPalConfigurationService.isExpressCheckoutEnabled());
    }

    private void addPayPalConnectComponent(ModelMap model) throws CMSItemNotFoundException {
        final PayPalConnectButtonComponentB2BModel payPalConnectModel;
        payPalConnectModel = cmsComponentService.getSimpleCMSComponent(PAYAPAL_CONNECT_BUTTON_COMPONENT_B2B);
        model.addAttribute(PAYPAL_CONNECT_COMPONENT, payPalConnectModel);
        model.addAttribute(CONTAINER_ID, payPalConnectModel.getButtonDiv());
        model.addAttribute(THEME, payPalConnectModel.getButtonTheme().toString().toLowerCase());
        model.addAttribute(BUTTON_TYPE, payPalConnectModel.getButtonType());
        model.addAttribute(BUTTON_SHAPE, payPalConnectModel.getButtonShape().toString().toLowerCase());
        model.addAttribute(BUTTON_SIZE, payPalConnectModel.getButtonSize().toString().toLowerCase());
        model.addAttribute(FULL_PAGE, payPalConnectModel.getFullPage());
        model.addAttribute(PAYPAL_CONNECT_SCRIPT, payPalConfigurationService.getPayPalConnectScript());
        model.addAttribute(PAYPAL_CONNECT_SCOPES, payPalConfigurationService.getPayPalConnectScopes());
        model.addAttribute(PAYPAL_CONNECT_RESPONSE_TYPE, payPalConfigurationService.getPayPalConnectResponseType());
        model.addAttribute(PAYPAL_CONNECT_RETURN_URL, payPalConfigurationService.getPayPalConnectReturnUrl());
        model.addAttribute(PAYPAL_ENV_CONFIGURATION, payPalConfigurationService.getEnvironmentType());
        model.addAttribute(CLIENT_ID, payPalConfigurationService.getClientID());
        model.addAttribute(IS_PAYPAL_CONNECT_ENABLED, payPalConnectModel.getEnabled());
    }

    private boolean isReplenishmentEnabled(HttpServletRequest request) {
        final Object isCreditCardReplenishment = request.getSession()
            .getAttribute(PAYPAL_CREDIT_CARD_REPLENISHMENT_AVAILABLE);
        return BooleanUtils.isTrue(
            sessionService.getAttribute(PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE))
            || (isCreditCardReplenishment != null && Boolean.parseBoolean(isCreditCardReplenishment.toString()));
    }
}
