package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.b2bfacade.PayPalB2BCheckoutFacade;
import com.paypal.hybris.data.PayPalBillingAgreementData;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractPageController;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CHECKOUT_MULTI_CONFIRMATION_PAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYPAL_FLOW_OPTION;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAY_PAL_REQUEST_REPLENISHMENT;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAY_PAL_REQUEST_SAVE_PAYMENT_INFO;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_EXPRESS_BILLING_AGREEMENT_FLOW;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ORDER_ID_PLACEHOLDER;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE;


@Controller
@RequestMapping(value = "/paypal/b2b/billing-agreement/checkout")
public class BillingAgreementController extends AbstractPageController {

    private static final String REDIRECT_TO_MULTISTEP_CHECKOUT_CONFIRMATION =
        REDIRECT_PREFIX + CHECKOUT_MULTI_CONFIRMATION_PAGE;
    private static final String FUNDING_PARAMETER = "funding";

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    @Resource(name = "defaultPayPalB2BCheckoutFacade")
    private PayPalB2BCheckoutFacade b2BCheckoutFacade;

    @RequestMapping(value = "/create-token")
    public ResponseEntity<String> getBillingAgreementToken(final HttpServletRequest request,
        final HttpServletResponse response) {
        final boolean skipShipping = !checkoutFacade.hasNoDeliveryAddress();
        return ResponseEntity.ok(checkoutFacade.createBillingAgreementToken(skipShipping));
    }

    @RequestMapping(value = "/response")
    public ResponseEntity<String> doHandleReplenishmentHopResponse(final HttpServletRequest request,
        final HttpServletResponse response) {
        final String billingAgreementToken = request.getParameter(PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN);
        final String checkoutFlow = request.getParameter(PAYPAL_FLOW_OPTION);
        final String isSavePaymentInfo = request.getParameter(PAY_PAL_REQUEST_SAVE_PAYMENT_INFO);
        final String paymentMethodType = request.getParameter(FUNDING_PARAMETER);
        if (Boolean.valueOf(request.getParameter(PAY_PAL_REQUEST_REPLENISHMENT))) {
            getSessionService().setAttribute(PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE, Boolean.TRUE);
        } else if (StringUtils.equals(PAYPAL_EXPRESS_BILLING_AGREEMENT_FLOW, checkoutFlow)) {
            b2BCheckoutFacade.setCardPaymentType();
        }
        final PayPalBillingAgreementData billingAgreement = checkoutFacade
            .createBillingAgreement(billingAgreementToken);
        final CCPaymentInfoData payPalPaymentSubscription = checkoutFacade
            .createPayPalPaymentSubscription(billingAgreement, PAYPAL_ORDER_ID_PLACEHOLDER,
                Boolean.valueOf(isSavePaymentInfo), paymentMethodType);
        checkoutFacade.setPaymentDetails(payPalPaymentSubscription.getId());
        checkoutFacade.updateCheckoutPaymentInfoOrderId(PAYPAL_ORDER_ID_PLACEHOLDER);
        return ResponseEntity.ok(CHECKOUT_MULTI_CONFIRMATION_PAGE);
    }

    @RequestMapping(value = "/express")
    public String processBillingAgreementExpressCheckout(final HttpServletRequest request,
        final HttpServletResponse response) {
        getSessionService().removeAttribute(PAYPAL_REPLENISHMENT_FLOW_SESSION_ATTRIBUTE);
        b2BCheckoutFacade.setCardPaymentType();
        checkoutFacade.processBillingAgreementExpressCheckout();
        return REDIRECT_TO_MULTISTEP_CHECKOUT_CONFIRMATION;
    }
}
