/**
 *
 */
package com.paypal.hybris.b2baddon.controllers.cms;

import com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants;
import com.paypal.hybris.b2baddon.model.PayPalMiniCartComponentB2BModel;
import de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.product.data.PriceData;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;


@Controller("PayPalMiniCartComponentB2BController")
@Scope("tenant")
@RequestMapping(value = Paypalb2baddonControllerConstants.Actions.Cms.PAYPAL_MINI_CART_COMPONENT)
public class PayPalMiniCartComponentController extends
    AbstractCMSAddOnComponentController<PayPalMiniCartComponentB2BModel> {

    private static final String TOTAL_PRICE = "totalPrice";
    private static final String TOTAL_ITEMS = "totalItems";
    private static final String TOTAL_DISPLAY = "totalDisplay";
    private static final String TOTAL_NO_DELIVERY = "totalNoDelivery";
    private static final String SUB_TOTAL = "subTotal";

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    /*
     * (non-Javadoc)
     *
     * @see
     * de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController#fillModel(javax.servlet.http
     * .HttpServletRequest, org.springframework.ui.Model,
     * de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel)
     */
    @Override
    protected void fillModel(final HttpServletRequest request, final Model model,
        final PayPalMiniCartComponentB2BModel component) {
        final CartData cartData = cartFacade.getMiniCart();
        model.addAttribute(SUB_TOTAL, cartData.getSubTotal());
        if (cartData.getDeliveryCost() != null) {
            final PriceData withoutDelivery = cartData.getDeliveryCost();
            withoutDelivery
                .setValue(cartData.getTotalPrice().getValue().subtract(cartData.getDeliveryCost().getValue()));
            model.addAttribute(TOTAL_NO_DELIVERY, withoutDelivery);
        } else {
            model.addAttribute(TOTAL_NO_DELIVERY, cartData.getTotalPrice());
        }
        model.addAttribute(TOTAL_PRICE, cartData.getTotalPrice());
        model.addAttribute(TOTAL_DISPLAY, component.getTotalDisplay());
        model.addAttribute(TOTAL_ITEMS, cartData.getTotalUnitCount());
    }

    @Override
    @RequestMappingOverride
    @RequestMapping
    public String handleGet(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        return super.handleGet(request, response, model);
    }

}
