/*
 * [y] hybris Platform
 *
 * Copyright (c) 2018 SAP SE or an SAP affiliate company.  All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */
package com.paypal.hybris.b2baddon.constants;


/**
 * Global class for all Paypalb2baddon web constants. You can add global constants for your extension into this class.
 */
public final class Paypalb2baddonWebConstants // NOSONAR
{

    public static final String EXPRESS_CHECKOUT = "EXPRESS_CHECKOUT";
    public static final String MARK_CHECKOUT = "MARK_CHECKOUT";
    public static final String PAY_PAL_REQUEST_ORDER_ID = "orderID";
    public static final String PAY_PAL_REQUEST_SAVE_PAYMENT_INFO = "isSavePaymentInfo";
    public static final String PAY_PAL_REQUEST_REPLENISHMENT = "isReplenishment";
    public static final String PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN = "billingAgreementToken";
    public static final String PAYPAL_FLOW_OPTION = "flow";
    public static final String PAYPAL_FUNDING = "funding";
    public static final String PAYMENT_INFOS = "paymentInfos";
    public static final String IS_ANONYMOUS_USER = "isAnonymousUser";

    public static final String CHECKOUT_MULTI_CONFIRMATION_PAGE = "/checkout/multi/summary/view";
    public static final String CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS = "/checkout/multi/delivery-address/add";
    public static final String PAYPAL_CHECKOUT_MULTI_SUMMARY_PLACE_ORDER = "/paypal/checkout/multi/summary/placeOrder";

    public static final String PAYPAL_CONNECT_AUTHORIZATION_CODE = "code";

    public static final String ADD_ON_PREFIX = "addon:";
    public static final String VIEW_PAGE_PREFIX = ADD_ON_PREFIX + "/" + Paypalb2baddonConstants.EXTENSIONNAME;
    public static final String CMS_REGISTER_PAGE_NAME = "SecureCustomerPortalRegisterPage";

    private Paypalb2baddonWebConstants() {
        //empty to avoid instantiating this constant class
    }

    public static final class Views
    {

        public static final String PAYPAL_CONNECT_REGISTRATION_PAGE = VIEW_PAGE_PREFIX + "/pages/login/additionalData";
        public static final String PAYPAL_CONNECT_SAVE_PAYMENT_INFO_PAGE = VIEW_PAGE_PREFIX + "/pages/login/savePaymentInfo";

        private Views()
        {
        }

    }

}
