<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="template" tagdir="/WEB-INF/tags/responsive/template" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="multiCheckout" tagdir="/WEB-INF/tags/responsive/checkout/multi" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="formElement" tagdir="/WEB-INF/tags/responsive/formElement" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="address" tagdir="/WEB-INF/tags/responsive/address" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>

<spring:htmlEscape defaultHtmlEscape="true"/>

<template:page pageTitle="${pageTitle}" hideHeaderLinks="true">
    <div class="row">
        <div class="col-sm-6">
            <div class="checkout-headline">
                <span class="glyphicon glyphicon-lock"></span>
                <spring:theme code="checkout.multi.secure.checkout"/>
            </div>
            <multiCheckout:checkoutSteps checkoutSteps="${checkoutSteps}" progressBarId="${progressBarId}">
                <jsp:body>
                    <c:if test="${not empty paymentFormUrl}">
                        <div class="checkout-paymentmethod">
                            <div class="checkout-indent">

                                <div class="headline"><spring:theme code="checkout.multi.paymentMethod"/></div>

                                <div class="span-14 append-1">
                                    <div id="checkoutContentPanelPayment" class="clearfix">
                                        <label for="paymentMethodPayPal">
                                            <cms:pageSlot position="PayPalSectionSlot" var="feature">
                                                <cms:component component="${feature}"/>
                                            </cms:pageSlot>
                                        </label>
                                    </div>

                                    <div class="form-group">
                                        <c:if test="${not empty paymentInfos}">
                                            <button type="button"
                                                    class="btn btn-default btn-block js-saved-payments">
                                                <spring:theme
                                                        code="checkout.multi.paymentMethod.addPaymentDetails.useSavedPaymentMethod"/></button>
                                        </c:if>
                                    </div>

                                    <div id="checkoutContentPanel" class="clearfix">

                                        <div class="payWithCardSection" style="display:none;">


                                            <ycommerce:testId code="paymentDetailsForm">

                                                <form:form id="silentOrderPostForm" name="silentOrderPostForm"
                                                           modelAttribute="sopPaymentDetailsForm"
                                                           action="${paymentFormUrl}" method="POST">
                                                    <input type="hidden" name="orderPage_receiptResponseURL"
                                                           value="${fn:escapeXml(silentOrderPageData.parameters['orderPage_receiptResponseURL'])}"/>
                                                    <input type="hidden" name="orderPage_declineResponseURL"
                                                           value="${fn:escapeXml(silentOrderPageData.parameters['orderPage_declineResponseURL'])}"/>
                                                    <input type="hidden" name="orderPage_cancelResponseURL"
                                                           value="${fn:escapeXml(silentOrderPageData.parameters['orderPage_cancelResponseURL'])}"/>
                                                    <c:forEach items="${sopPaymentDetailsForm.signatureParams}"
                                                               var="entry" varStatus="status">
                                                        <input type="hidden" id="${fn:escapeXml(entry.key)}"
                                                               name="${fn:escapeXml(entry.key)}"
                                                               value="${fn:escapeXml(entry.value)}"/>
                                                    </c:forEach>
                                                    <c:forEach
                                                            items="${sopPaymentDetailsForm.subscriptionSignatureParams}"
                                                            var="entry" varStatus="status">
                                                        <input type="hidden" id="${fn:escapeXml(entry.key)}"
                                                               name="${fn:escapeXml(entry.key)}"
                                                               value="${fn:escapeXml(entry.value)}"/>
                                                    </c:forEach>
                                                    <input type="hidden"
                                                           value="${fn:escapeXml(silentOrderPageData.parameters['billTo_email'])}"
                                                           name="billTo_email" id="billTo_email">

                                                    <div class="form-group">
                                                        <formElement:formSelectBox idKey="card_cardType"
                                                                                   labelKey="payment.cardType"
                                                                                   path="card_cardType"
                                                                                   selectCSSClass="form-control"
                                                                                   mandatory="true" skipBlank="false"
                                                                                   skipBlankMessageKey="payment.cardType.pleaseSelect"
                                                                                   items="${sopCardTypes}"
                                                                                   tabindex="1"/>
                                                    </div>

                                                    <div class="form-group">
                                                        <formElement:formInputBox idKey="card_nameOnCard"
                                                                                  labelKey="payment.nameOnCard"
                                                                                  path="card_nameOnCard"
                                                                                  inputCSS="form-control" tabindex="2"
                                                                                  mandatory="false"/>
                                                    </div>

                                                    <div class="form-group">
                                                        <formElement:formInputBox idKey="card_accountNumber"
                                                                                  labelKey="payment.cardNumber"
                                                                                  path="card_accountNumber"
                                                                                  inputCSS="form-control"
                                                                                  mandatory="true" tabindex="3"
                                                                                  autocomplete="off"/>
                                                    </div>

                                                    <fieldset id="startDate">
                                                        <legend>Start date</legend>
                                                        <label for="" class="control-label"><spring:theme
                                                                code="payment.startDate"/></label>
                                                        <div class="row">
                                                            <div class="col-xs-6">
                                                                <formElement:formSelectBox idKey="StartMonth"
                                                                                           selectCSSClass="form-control"
                                                                                           labelKey="payment.month"
                                                                                           path="card_startMonth"
                                                                                           mandatory="true"
                                                                                           skipBlank="false"
                                                                                           skipBlankMessageKey="payment.month"
                                                                                           items="${months}"
                                                                                           tabindex="4"/>
                                                            </div>
                                                            <div class="col-xs-6">
                                                                <formElement:formSelectBox idKey="StartYear"
                                                                                           selectCSSClass="form-control"
                                                                                           labelKey="payment.year"
                                                                                           path="card_startYear"
                                                                                           mandatory="true"
                                                                                           skipBlank="false"
                                                                                           skipBlankMessageKey="payment.year"
                                                                                           items="${startYears}"
                                                                                           tabindex="7"/>
                                                            </div>
                                                        </div>
                                                    </fieldset>


                                                    <fieldset id="cardDate">
                                                        <legend>Card date</legend>
                                                        <label for="" class="control-label"><spring:theme
                                                                code="payment.expiryDate"/></label>
                                                        <div class="row">
                                                            <div class="col-xs-6">
                                                                <formElement:formSelectBox idKey="ExpiryMonth"
                                                                                           selectCSSClass="form-control"
                                                                                           labelKey="payment.month"
                                                                                           path="card_expirationMonth"
                                                                                           mandatory="true"
                                                                                           skipBlank="false"
                                                                                           skipBlankMessageKey="payment.month"
                                                                                           items="${months}"
                                                                                           tabindex="6"/>
                                                            </div>
                                                            <div class="col-xs-6">
                                                                <formElement:formSelectBox idKey="ExpiryYear"
                                                                                           selectCSSClass="form-control"
                                                                                           labelKey="payment.year"
                                                                                           path="card_expirationYear"
                                                                                           mandatory="true"
                                                                                           skipBlank="false"
                                                                                           skipBlankMessageKey="payment.year"
                                                                                           items="${expiryYears}"
                                                                                           tabindex="7"/>
                                                            </div>
                                                        </div>
                                                    </fieldset>

                                                    <div class="row">
                                                        <div class="col-xs-6">
                                                            <formElement:formInputBox idKey="card_cvNumber"
                                                                                      labelKey="payment.cvn"
                                                                                      path="card_cvNumber"
                                                                                      inputCSS="form-control"
                                                                                      mandatory="true" tabindex="8"/>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-xs-6">
                                                            <div id="issueNum">
                                                                <formElement:formInputBox idKey="card_issueNumber"
                                                                                          labelKey="payment.issueNumber"
                                                                                          path="card_issueNumber"
                                                                                          inputCSS="text"
                                                                                          mandatory="false"
                                                                                          tabindex="9"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <sec:authorize access="!hasAnyRole('ROLE_ANONYMOUS')">
                                                      <c:if test="${isBillingAgreementFlow}">
                                                        <formElement:formCheckbox idKey="savePaymentMethod"
                                                                                  labelKey="checkout.multi.sop.savePaymentInfo"
                                                                                  path="savePaymentInfo"
                                                                                  inputCSS="" labelCSS=""
                                                                                  mandatory="false" tabindex="10"/>
                                                      </c:if>
                                                    </sec:authorize>

                                                    <hr/>
                                                    <div class="headline">
                                                        <spring:theme
                                                                code="checkout.multi.paymentMethod.addPaymentDetails.billingAddress"/>
                                                    </div>

                                                    <c:if test="${cartData.deliveryItemsQuantity > 0}">

                                                        <div id="useDeliveryAddressData"
                                                             data-titlecode="${fn:escapeXml(deliveryAddress.titleCode)}"
                                                             data-firstname="${fn:escapeXml(deliveryAddress.firstName)}"
                                                             data-lastname="${fn:escapeXml(deliveryAddress.lastName)}"
                                                             data-line1="${fn:escapeXml(deliveryAddress.line1)}"
                                                             data-line2="${fn:escapeXml(deliveryAddress.line2)}"
                                                             data-town="${fn:escapeXml(deliveryAddress.town)}"
                                                             data-postalcode="${fn:escapeXml(deliveryAddress.postalCode)}"
                                                             data-countryisocode="${fn:escapeXml(deliveryAddress.country.isocode)}"
                                                             data-regionisocode="${fn:escapeXml(deliveryAddress.region.isocodeShort)}"
                                                             data-address-id="${fn:escapeXml(deliveryAddress.id)}"
                                                        ></div>
                                                        <formElement:formCheckbox
                                                                path="useDeliveryAddress"
                                                                idKey="useDeliveryAddress"
                                                                labelKey="checkout.multi.sop.useMyDeliveryAddress"
                                                                tabindex="11"/>
                                                    </c:if>

                                                    <input type="hidden"
                                                           value="${fn:escapeXml(silentOrderPageData.parameters['billTo_email'])}"
                                                           class="text" name="billTo_email" id="billTo_email">
                                                    <address:billAddressFormSelector supportedCountries="${countries}"
                                                                                     regions="${regions}"
                                                                                     tabindex="12"/>

                                                    <p class="help-block"><spring:theme
                                                            code="checkout.multi.paymentMethod.seeOrderSummaryForMoreInformation"/></p>

                                                </form:form>
                                            </ycommerce:testId>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button type="button"
                                class="btn btn-primary btn-block submit_silentOrderPostForm checkout-next"><spring:theme
                                code="checkout.multi.paymentMethod.continue"/></button>
                        <div id="mark-paypal-button-container" class="checkout-next" style="text-align:center"></div>
                        <div id="errorMessage"><span></span></div>
                    </c:if>

                    <c:if test="${not empty paymentInfos}">
                        <div id="savedpayments">
                            <div id="savedpaymentstitle">
                                <div class="headline">
                                    <span class="headline-text"><spring:theme
                                            code="checkout.multi.paymentMethod.addPaymentDetails.useSavedPaymentMethod"/></span>
                                </div>
                            </div>
                            <div id="savedpaymentsbody">
                                <spring:url var="choosePaymentMethodUrl"
                                            value="{contextPath}/paypal/checkout/multi/payment-method/choose"
                                            htmlEscape="false">
                                    <spring:param name="contextPath" value="${request.contextPath}"/>
                                </spring:url>
                                <c:forEach items="${paymentInfos}" var="paymentInfo" varStatus="status">
                                    <div class="saved-payment-entry">
                                        <form action="${fn:escapeXml(choosePaymentMethodUrl)}" method="GET">
                                            <input type="hidden" name="selectedPaymentMethodId"
                                                   value="${fn:escapeXml(paymentInfo.id)}"/>
                                            <ul>
                                                <c:choose>
                                                    <c:when test="${paymentInfo.cardType eq 'paypal'}">
                                                        <br><img height="38" width="56" class="paypal-icon"
                                                                 src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png" alt="PayPal icon"/>
                                                        ${fn:escapeXml(paymentInfo.payerEmail)}
                                                    </c:when>
                                                    <c:when test="${paymentInfo.cardType eq 'card'}">
                                                        <br><img class="paypal-icon" height="38" width="56"
                                                                 src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png"
                                                                 alt="PayPal icon"/>
                                                        PayPal Debit/Credit Card <br/>
                                                        ${fn:escapeXml(paymentInfo.payerEmail)}
                                                    </c:when>
                                                    <c:otherwise>
                                                        <span>
                                                            <c:if test="${paymentInfo.defaultPaymentInfo}">
                                                            <strong>
                                                                </c:if>
                                                                    ${fn:escapeXml(paymentInfo.accountHolderName)}<c:if test="${paymentInfo.defaultPaymentInfo}" >&nbsp;(<spring:theme code="text.default" />)</c:if>
                                                                <c:if test="${paymentInfo.defaultPaymentInfo}" ></strong></c:if>
                                                        </span> <br/>
                                                        <span>${fn:escapeXml(paymentInfo.cardTypeData.name)}</span> <br/>
                                                        <span>
                                                            <ycommerce:testId code="paymentDetails_item_cardNumber_text" >${fn:escapeXml(paymentInfo.cardNumber)}</ycommerce:testId>
                                                        </span> <br/>
                                                        <span>
                                                            <c:if test="${paymentInfo.expiryMonth lt 10}">0</c:if>
                                                                ${fn:escapeXml(paymentInfo.expiryMonth)}&nbsp;/&nbsp;${fn:escapeXml(paymentInfo.expiryYear)}
                                                        </span>
                                                    </c:otherwise>
                                                </c:choose>
                                                <c:if test="${paymentInfo.billingAddress ne null}">
                                                    <br/>${fn:escapeXml(paymentInfo.billingAddress.line1)}
                                                    <br/>${fn:escapeXml(paymentInfo.billingAddress.town)}&nbsp;${fn:escapeXml(paymentInfo.billingAddress.region.isocodeShort)}
                                                    <br/>${fn:escapeXml(paymentInfo.billingAddress.country.name)}&nbsp;${fn:escapeXml(paymentInfo.billingAddress.postalCode)}
                                                </c:if>
                                            </ul>
                                            <c:choose>
                                                <c:when test="${paymentInfo.defaultPaymentInfo}">
                                                    <button type="submit" class="btn btn-primary btn-block default-payment-method"
                                                            tabindex="${fn:escapeXml((status.count * 2) - 1)}"><spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.useDefaultPaymentDetails"/></button>
                                                </c:when>
                                                <c:otherwise>
                                                    <button type="submit" class="btn btn-primary btn-block"
                                                            tabindex="${fn:escapeXml((status.count * 2) - 1)}"><spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.useThesePaymentDetails"/></button>
                                                </c:otherwise>
                                            </c:choose>
                                        </form>
                                    </div>
                                </c:forEach>
                            </div>
                        </div>
                    </c:if>

                </jsp:body>
            </multiCheckout:checkoutSteps>
        </div>

        <div class="col-sm-6 hidden-xs">
            <multiCheckout:checkoutOrderDetails cartData="${cartData}" showDeliveryAddress="true"
                                                showPaymentInfo="false" showTaxEstimate="false" showTax="true"/>
        </div>

        <div class="col-sm-12 col-lg-12">
            <cms:pageSlot position="SideContent" var="feature" element="div" class="checkout-help">
                <cms:component component="${feature}"/>
            </cms:pageSlot>
        </div>
    </div>

</template:page>
