<%@ tag body-content="empty" trimDirectiveWhitespaces="true" %>
<%@ attribute name="order" required="true" type="de.hybris.platform.commercefacades.order.data.AbstractOrderData" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<spring:htmlEscape defaultHtmlEscape="true"/>
<div class="label-order">
    <spring:theme code="text.account.paymentType"/>
</div>
<div class="value-order">
    <c:choose>
        <c:when test="${order.paymentInfo.cardType eq 'paypal'}">
            <img src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png" alt="PayPal icon"/>
            <spring:theme code="paymentMethod.type"/>
            <br/>
            ${fn:escapeXml(order.paymentInfo.payerEmail)}
        </c:when>
        <c:when test="${order.paymentInfo.cardType eq 'paypal_credit'}">
            <img src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/ppc-acceptance-small.png" alt="PayPal icon"/>
            <spring:theme code="paymentMethod.type"/>
            <br/>
            ${fn:escapeXml(order.paymentInfo.payerEmail)}
        </c:when>
        <c:when test="${order.paymentInfo.cardType eq 'local_payment'}">
            <spring:theme code="paymentMethod.lpm"/>
            <br/>
        </c:when>
        <c:when test="${order.paymentInfo.cardType eq 'venmo'}">
            <img  src="${contextPath}/_ui/addons/paypaladdon/responsive/common/images/venmo_acceptance_mark.svg" alt="Venmo icon"/>
            <spring:theme code="paymentMethod.venmo"/>
            <br/>
            ${fn:escapeXml(order.paymentInfo.payerEmail)}
        </c:when>
        <c:when test="${order.paymentInfo.cardType eq 'card'}">
            <img class="paypal-icon"
                 src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png"
                 alt="PayPal icon"/>
            <c class="pp-account-email-card"><spring:theme code="paymentMethod.credit-debit"/>,
                    ${fn:escapeXml(order.paymentInfo.accountHolderName)},
                    ${fn:escapeXml(order.paymentInfo.payerEmail)} </c>
        </c:when>
        <c:otherwise>
            ${fn:escapeXml(order.paymentInfo.cardTypeData.name)}
            ${fn:escapeXml(order.paymentInfo.cardNumber)}
        </c:otherwise>
    </c:choose>
</div>

