<%@ attribute name="cartData" required="true" type="de.hybris.platform.commercefacades.order.data.CartData" %>
<%@ attribute name="paymentInfo" required="true"
              type="de.hybris.platform.commercefacades.order.data.CCPaymentInfoData" %>
<%@ attribute name="showPaymentInfo" required="false" type="java.lang.Boolean" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="format" tagdir="/WEB-INF/tags/shared/format" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<c:if test="${not empty paymentInfo && showPaymentInfo}">
    <ul class="checkout-order-summary-list">
        <li class="checkout-order-summary-list-heading">
            <div class="title">
                <spring:theme
                        code="checkout.summary.paymentMethod.securityCode.whatIsThis.description"
                        var="securityWhatText"/>
            </div>
            <div class="title"><spring:theme code="checkout.multi.payment" text="Payment:"></spring:theme></div>
            <div class="address">
                <c:choose>
                    <c:when test="${paymentInfo.cardType eq 'paypal'}">
                        <img class="paypal-icon"
                             src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png"
                             alt="PayPal icon"/>
                        <c class="pp-account-email">${fn:escapeXml(paymentInfo.payerEmail)}</c>
                    </c:when>
                    <c:when test="${paymentInfo.cardType eq 'paypal_credit'}">
                        <img class="paypal-icon"
                             src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/ppc-acceptance-small.png"
                             alt="PayPal icon"/>
                        <c class="pp-account-email credit">${fn:escapeXml(paymentInfo.payerEmail)}</c>
                    </c:when>
                    <c:when test="${paymentInfo.cardType eq 'venmo'}">
                        <img class="paypal-icon"
                             src="${contextPath}/_ui/addons/paypaladdon/responsive/common/images/venmo_acceptance_mark.svg"
                             alt="Venmo icon"/>
                        <c class="venmo-account-email">${fn:escapeXml(paymentInfo.payerEmail)}</c>
                    </c:when>
                    <c:when test="${paymentInfo.cardType eq 'card'}">
                        <img class="paypal-icon"
                             src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/pp-acceptance-small.png"
                             alt="PayPal icon"/>
                        <c class="pp-account-email-card"><spring:theme code="paymentMethod.credit-debit"/>,
                                ${fn:escapeXml(paymentInfo.accountHolderName)},
                                ${fn:escapeXml(paymentInfo.payerEmail)} </c>
                    </c:when>
                    <c:otherwise>
                        ${fn:escapeXml(paymentInfo.accountHolderName)},
                        ${fn:escapeXml(paymentInfo.cardTypeData.name)},
                        ${fn:escapeXml(paymentInfo.cardNumber)},
                        ${paymentInfo.expiryMonth}/${paymentInfo.expiryYear}
                    </c:otherwise>
                </c:choose>
            </div>
        </li>
    </ul>
</c:if>

