package com.paypal.hybris.addon.controllers.pages;

import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.annotations.RequireHardLogIn;
import de.hybris.platform.yacceleratorstorefront.controllers.pages.checkout.steps.PaymentMethodCheckoutStepController;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ORDER_ID_PLACEHOLDER;

@Controller
@RequestMapping(value = "/paypal/checkout/multi/payment-method")
public class PayPalPaymentMethodCheckoutStepController extends PaymentMethodCheckoutStepController {

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade payPalCheckoutFacade;

    @Override
    @GetMapping(value = "/choose")
    @RequireHardLogIn
    public String doSelectPaymentMethod(@RequestParam("selectedPaymentMethodId") final String selectedPaymentMethodId) {
        if (StringUtils.isNotBlank(selectedPaymentMethodId)) {
            payPalCheckoutFacade.setPaymentDetails(selectedPaymentMethodId);
            payPalCheckoutFacade.updateCheckoutPaymentInfoOrderId(PAYPAL_ORDER_ID_PLACEHOLDER);
        }
        return getCheckoutStep().nextStep();
    }
}
