package com.paypal.hybris.addon.controllers.pages;

import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.CHECKOUT_MULTI_CONFIRMATION_PAGE;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.EXPRESS_CHECKOUT;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.MARK_CHECKOUT;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYPAL_CHECKOUT_MULTI_SUMMARY_PLACE_ORDER;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYPAL_FLOW_OPTION;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYPAL_FUNDING;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAY_PAL_REQUEST_ORDER_ID;

import com.paypal.hybris.data.PayPalOrderDetailsData;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalGuestCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractPageController;
import de.hybris.platform.acceleratorstorefrontcommons.security.GUIDCookieStrategy;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.core.enums.CreditCardType;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value = "/paypal/checkout/hop")
public class PayPalHopPaymentResponseController extends AbstractPageController {


    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    @Resource(name = "guidCookieStrategy")
    private GUIDCookieStrategy guidCookieStrategy;

    @Resource(name = "payPalGuestCheckoutFacade")
    private PayPalGuestCheckoutFacade payPalGuestCheckoutFacade;


    /*
     * (non-Javadoc)
     *
     * @see
     * de.hybris.platform.storefront.controllers.pages.checkout.steps.HopPaymentResponseController#doHandleHopResponse
     * (javax.servlet.http.HttpServletRequest)
     */
    @RequestMapping(value = "/response")
    public ResponseEntity<String> doHandleHopResponse(final HttpServletRequest request,
        final HttpServletResponse response) {
        final String orderId = request.getParameter(PAY_PAL_REQUEST_ORDER_ID);
        final String checkoutType = request.getParameter(PAYPAL_FLOW_OPTION);
        final String fundingSource = request.getParameter(PAYPAL_FUNDING);
        final PayPalOrderDetailsData orderDetailsData = checkoutFacade.getPayPalOrderDetails(orderId);
        if (StringUtils.equals(EXPRESS_CHECKOUT, checkoutType)) {
            if (getUserFacade().isAnonymousUser()) {
                payPalGuestCheckoutFacade.processCheckoutForAnonymous(orderDetailsData.getShippingAddress());
                guidCookieStrategy.setCookie(request, response);
            }
            checkoutFacade.processExpressCheckout(orderDetailsData, fundingSource);
        } else if (StringUtils.equals(MARK_CHECKOUT, checkoutType)) {
            final CCPaymentInfoData payPalPaymentSubscription = checkoutFacade
                .updatePayPalPaymentSubscription(orderDetailsData, checkoutFacade.getCheckoutCart().getPaymentInfo());
            checkoutFacade.setPaymentDetails(payPalPaymentSubscription.getId());
        }
        return ResponseEntity.ok(getPayPalCheckoutResponseUrl());
    }

    @PostMapping(value = "/create-order")
    public ResponseEntity<String> createOrderResponse(final HttpServletRequest request) {
        final String orderID = checkoutFacade.createPayPalOrder();
        final String fundingSource = request.getParameter(PAYPAL_FUNDING);
        final CreditCardType paymentType = checkoutFacade.setCreditCardType(fundingSource);
        final CCPaymentInfoData payPalPaymentSubscription = checkoutFacade
            .createPayPalPaymentSubscriptionForMarkCheckout(orderID, paymentType);
        checkoutFacade.setPaymentDetails(payPalPaymentSubscription.getId());
        return ResponseEntity.ok(orderID);
    }

    private boolean isReadyForConfirmation() {
        return !checkoutFacade.hasNoDeliveryAddress() && !checkoutFacade.hasNoPaymentInfo() && !checkoutFacade
            .hasNoDeliveryMode();
    }

    private String getPayPalCheckoutResponseUrl() {
        String responseUrl = CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS;
        if (checkoutFacade.isLocalPaymentFlow()) {
            responseUrl = PAYPAL_CHECKOUT_MULTI_SUMMARY_PLACE_ORDER;
        } else if (isReadyForConfirmation()) {
            responseUrl = CHECKOUT_MULTI_CONFIRMATION_PAGE;
        }
        return responseUrl;
    }
}
