/**
 *
 */
package com.paypal.hybris.addon.controllers.pages;

import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.CONNECT_LOGIN_SAVE_PAYMENT_INFO_AND_ADDRESS_PAGE;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.REDIRECT;
import static com.paypal.hybris.addon.controllers.PaypaladdonControllerConstants.Views.Pages.Login.SAVE_PAYMENT_INFO_PAGE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ORDER_ID_PLACEHOLDER;

import com.paypal.hybris.core.service.PayPalConnectService;
import com.paypal.hybris.core.service.PayPalCustomerAccountService;
import com.paypal.hybris.data.PayPalBillingAgreementData;
import com.paypal.hybris.data.PayPalCheckoutData;
import com.paypal.hybris.data.PayPalConnectAddressData;
import com.paypal.hybris.data.PayPalConnectUserData;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalRegistrationUserFacade;
import de.hybris.platform.acceleratorfacades.flow.CheckoutFlowFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractLoginPageController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.acceleratorstorefrontcommons.forms.GuestForm;
import de.hybris.platform.acceleratorstorefrontcommons.forms.LoginForm;
import de.hybris.platform.acceleratorstorefrontcommons.forms.RegisterForm;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.pages.AbstractPageModel;
import de.hybris.platform.cms2.model.pages.ContentPageModel;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.yacceleratorstorefront.controllers.ControllerConstants;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;


@Controller
@RequestMapping(value = "/connect/login")
public class PayPalConnectLoginController extends AbstractLoginPageController {

    private static final Logger LOG = Logger.getLogger(PayPalConnectLoginController.class);

    private static final String PAYPAL_CONNECT_GLOBAL_ERROR = "paypal.connect.registration.global.error";
    private static final String PAYPAL_CONNECT_SERVLET_PATH = "/checkout";
    private static final String PAYPAL_PAGE_INDICATOR = "isLoginPage";

    private static final String PAYER_ID = "payerId";
    private static final String ADDRESS_DATA = "addressData";
    private static final String FUNDING_PARAMETER = "funding";
    private static final String IS_REQUEST_FROM_CHECKOUT_PAGE = "isRequestFromCheckoutPage";
    private static final String CREATE_BILLING_AGREEMENT_TOKEN = "createBillingAgreementTokenUrl";
    private static final String CREATE_BILLING_AGREEMENT_TOKEN_URL = "connect/login/create-token";
    private static final String BILLING_AGREEMENT_PROCESS = "billingAgreementProcessUrl";
    private static final String BILLING_AGREEMENT_PROCESS_URL = "connect/login/response";
    private static final String BILLING_AGREEMENT_CHECKOUT_PROCESS_URL = "connect/login/response/checkout";
    private static final String SAVE_PAYMENT_INFO = "savePaymentInfoUrl";
    private static final String SAVE_PAYMENT_INFO_URL = "connect/login/savePaymentInfo";
    private static final String SAVE_PAYMENT_INFO_CHECKOUT_URL = "connect/login/savePaymentInfo/checkout";
    private static final String LOGIN_PAGE = "LOGIN";
    private static final String PAYPAL_CHECKOUT_DATA = "payPalCheckoutData";

    private HttpSessionRequestCache httpSessionRequestCache;

    @Resource(name = "payPalConnectService")
    private PayPalConnectService payPalConnectService;

    @Resource(name = "payPalCustomerAccountService")
    private PayPalCustomerAccountService payPalCustomerAccountService;

    @Resource(name = "payPalRegistrationUserFacade")
    private PayPalRegistrationUserFacade userFacade;

    @Resource(name = "checkoutFlowFacade")
    private CheckoutFlowFacade checkoutFlowFacade;

    @Resource(name = "sessionService")
    private SessionService sessionService;

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    @Override
    protected String getView() {
        final boolean isLoginPage = sessionService.getAttribute(PAYPAL_PAGE_INDICATOR);
        sessionService.removeAttribute(PAYPAL_PAGE_INDICATOR);
        if (isLoginPage) {
            return ControllerConstants.Views.Pages.Account.AccountLoginPage;
        }
        return ControllerConstants.Views.Pages.Checkout.CheckoutLoginPage;
    }

    @Override
    protected String getSuccessRedirect(final HttpServletRequest request, final HttpServletResponse response) {
        if (isRequestFromCheckoutPage(request)) {
            if (hasItemsInCart()) {
                return getCheckoutUrl();
            }
            return "/checkout";
        }
        if (httpSessionRequestCache.getRequest(request, response) != null) {
            return httpSessionRequestCache.getRequest(request, response).getRedirectUrl();
        }
        return "/";
    }

    private boolean isRequestFromCheckoutPage(final HttpServletRequest request){
        return request.getServletPath().contains(PAYPAL_CONNECT_SERVLET_PATH);
    }

    @Override
    protected AbstractPageModel getCmsPage() throws CMSItemNotFoundException {
        final boolean isLoginPage = sessionService.getAttribute(PAYPAL_PAGE_INDICATOR);
        if (isLoginPage) {
            return getContentPageForLabelOrId("login");
        }
        return getContentPageForLabelOrId("checkout-login");
    }

    private String handleRegistrationError(final Model model, final HttpServletRequest request) throws CMSItemNotFoundException {
        String view;
        ContentPageModel pageModel;
        if (isRequestFromCheckoutPage(request)) {
            pageModel = getContentPageForLabelOrId("checkout-login");
            view = ControllerConstants.Views.Pages.Checkout.CheckoutLoginPage;
        } else {
            pageModel = getContentPageForLabelOrId("login");
            view = ControllerConstants.Views.Pages.Account.AccountLoginPage;
        }
        storeCmsPageInModel(model, pageModel);
        setUpMetaDataForContentPage(model, pageModel);
        addRegistrationConsentDataToModel(model);
        return view;
    }


    @Resource(name = "httpSessionRequestCache")
    public void setHttpSessionRequestCache(final HttpSessionRequestCache accHttpSessionRequestCache) {
        this.httpSessionRequestCache = accHttpSessionRequestCache;
    }

    @RequestMapping(method = RequestMethod.GET)
    public String doLogin(@RequestHeader(value = "referer", required = false) final String referer,
        final RegisterForm form, final Model model,
        final HttpServletRequest request, final HttpServletResponse response,
        @RequestParam(required = false) String code, HttpSession session)
        throws CMSItemNotFoundException {
        sessionService.setAttribute(PAYPAL_PAGE_INDICATOR, true);
        if (code == null) {
            storeReferer(referer, request, response);
            return getDefaultLoginPage(false, session, model);
        }
        final String accessToken = payPalConnectService.exchangeAuthorizationCodeToAccessToken(code);
        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);
        storeReferer(referer, request, response);
        return processRequest(model, form, request, response, accessToken, userData);
    }

    @RequestMapping(value = "/checkout", method = RequestMethod.GET)
    public String doCheckoutLogin(final Model model, final RegisterForm form, final HttpServletRequest request,
        final HttpServletResponse response, @RequestParam(required = false) final String code, HttpSession session)
        throws CMSItemNotFoundException
    {
        sessionService.setAttribute(PAYPAL_PAGE_INDICATOR, false);
        if (code == null) {
            model.addAttribute("expressCheckoutAllowed", Boolean.valueOf(checkoutFlowFacade.isExpressCheckoutEnabledForStore()));
            return getDefaultLoginPage(false, session, model);
        }
        final String accessToken = payPalConnectService.exchangeAuthorizationCodeToAccessToken(code);
        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);
        model.addAttribute("expressCheckoutAllowed", Boolean.valueOf(checkoutFlowFacade.isExpressCheckoutEnabledForStore()));
        return processRequest(model, form, request, response, accessToken, userData);
    }

    private String processRequest(Model model, RegisterForm form, HttpServletRequest request, HttpServletResponse response,
        String accessToken, PayPalConnectUserData userData) throws CMSItemNotFoundException {
        if (payPalCustomerAccountService.isCustomerWithPayerIdExist(userData.getPayer_id())) {
            return processLogin(request, response, userData.getPayer_id());
        } else {
            try {
                HttpSession session = request.getSession();
                session.setAttribute(PAYER_ID, userData.getPayer_id());
                session.setAttribute(ADDRESS_DATA, userData.getAddress());
                session.setAttribute(IS_REQUEST_FROM_CHECKOUT_PAGE, isRequestFromCheckoutPage(request));
                userFacade.registerPayPalUser(accessToken);
                userFacade.setPayerIdToUser(userData.getEmails().get(0).getValue().toLowerCase(), userData.getPayer_id());
                return REDIRECT + CONNECT_LOGIN_SAVE_PAYMENT_INFO_AND_ADDRESS_PAGE;
            } catch (DuplicateUidException e) {
                form.setTermsCheck(false);
                model.addAttribute(form);
                model.addAttribute(new LoginForm());
                model.addAttribute(new GuestForm());
                GlobalMessages.addErrorMessage(model, PAYPAL_CONNECT_GLOBAL_ERROR);
                return handleRegistrationError(model, request);
            }
        }
    }

    @RequestMapping(value = "/savePaymentInfoAndAddressPage", method = RequestMethod.GET)
    public String getSavePaymentInfoAndAddressPage(final Model model, HttpServletRequest request) throws CMSItemNotFoundException {
        setModelAttributesForPaymentAndAddressInfo(request, model);
        storeCmsPageInModel(model, getCmsPage());
        setUpMetaDataForContentPage(model, (ContentPageModel) getCmsPage());
        return SAVE_PAYMENT_INFO_PAGE;
    }

    @PostMapping(value = {"/savePaymentInfo", "/savePaymentInfo/checkout" })
    public String doSavePaymentInfo(final RegisterForm form, final HttpServletRequest request,
                                    final HttpServletResponse response,
                                    final HttpSession session, final Model model) {
        model.addAttribute(form);
        final String payerId = (String) session.getAttribute(PAYER_ID);
        session.removeAttribute(PAYER_ID);
        session.removeAttribute(ADDRESS_DATA);
        session.removeAttribute(IS_REQUEST_FROM_CHECKOUT_PAGE);
        return processLogin(request, response, payerId);
    }

    @RequestMapping(value = "/create-token")
    public ResponseEntity<String> getBillingAgreementToken() {
        final boolean skipShipping = !checkoutFacade.hasNoDeliveryAddress();
        return ResponseEntity.ok(checkoutFacade.createBillingAgreementToken(skipShipping));
    }

    @PostMapping(value = {"/response", "/response/checkout"})
    public String doHandlePayPalResponse(final HttpServletRequest request, final HttpServletResponse response,
                                         final HttpSession session, final Model model,
                                         RedirectAttributes redirectAttributes) {
        final String billingAgreementToken = request.getParameter(PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN);
        final String paymentMethodType = request.getParameter(FUNDING_PARAMETER);
        final String payerId = (String) session.getAttribute(PAYER_ID);
        final PayPalConnectAddressData addressData = (PayPalConnectAddressData) session.getAttribute(ADDRESS_DATA);
        try {
            final PayPalBillingAgreementData billingAgreement = checkoutFacade
                    .createBillingAgreement(billingAgreementToken);
            checkoutFacade
                    .createPayPalPaymentSubscriptionForNewUser(billingAgreement, PAYPAL_ORDER_ID_PLACEHOLDER, paymentMethodType, payerId);
            GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.INFO_MESSAGES_HOLDER, "paypal.connect.saved.payment.method");
        } catch(Exception e) {
            LOG.error("Error during adding payment method for new customer", e);
            GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.INFO_MESSAGES_HOLDER, "paypal.connect.saved.payment.method.error");
        }
        try {
            if (addressData != null) {
                checkoutFacade.addAddressForNewUser(addressData, payerId);
                GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.INFO_MESSAGES_HOLDER, "paypal.connect.saved.address");
            }
        } catch(Exception e) {
            LOG.error("Error during adding address for new customer", e);
            GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.INFO_MESSAGES_HOLDER, "paypal.connect.saved.address.error");
        }
        session.removeAttribute(PAYER_ID);
        session.removeAttribute(ADDRESS_DATA);
        session.removeAttribute(IS_REQUEST_FROM_CHECKOUT_PAGE);
        return processLogin(request, response, payerId);
    }

    private String processLogin(final HttpServletRequest request, final HttpServletResponse response,
        final String payerId) {
        final CustomerData customer = payPalCustomerAccountService.getCustomerByPayerId(payerId);
        final String password = payPalCustomerAccountService.setTempPassword(payerId);
        this.getAutoLoginStrategy().login(customer.getUid(), password, request, response);
        payPalCustomerAccountService.clearTempPassword(payerId);
        return "redirect:" + this.getSuccessRedirect(request, response);
    }

    protected void storeReferer(final String referer, final HttpServletRequest request,
        final HttpServletResponse response) {
        if (StringUtils.isNotBlank(referer) && !StringUtils.endsWith(referer, "/connect/login")
            && StringUtils.contains(referer, request.getServerName())) {
            httpSessionRequestCache.saveRequest(request, response);
        }
    }

    private boolean hasItemsInCart() {
        final CartData cartData = getCheckoutFlowFacade().getCheckoutCart();

        return cartData.getEntries() != null && !cartData.getEntries().isEmpty();
    }

    private static String getCheckoutUrl() {
        return "/checkout/multi/delivery-address/add";
    }

    protected CheckoutFlowFacade getCheckoutFlowFacade() {
        return checkoutFlowFacade;
    }

    private void setModelAttributesForPaymentAndAddressInfo(HttpServletRequest request, Model model) {
        PayPalCheckoutData checkoutData = checkoutFacade.getPayPalCheckoutData(LOGIN_PAGE);
        model.addAttribute(PAYPAL_CHECKOUT_DATA, checkoutData);
        model.addAttribute(CREATE_BILLING_AGREEMENT_TOKEN, CREATE_BILLING_AGREEMENT_TOKEN_URL);
        HttpSession session = request.getSession();
        if ((boolean) session.getAttribute(IS_REQUEST_FROM_CHECKOUT_PAGE)) {
            model.addAttribute(SAVE_PAYMENT_INFO, SAVE_PAYMENT_INFO_CHECKOUT_URL);
            model.addAttribute(BILLING_AGREEMENT_PROCESS, BILLING_AGREEMENT_CHECKOUT_PROCESS_URL);
        } else {
            model.addAttribute(SAVE_PAYMENT_INFO, SAVE_PAYMENT_INFO_URL);
            model.addAttribute(BILLING_AGREEMENT_PROCESS, BILLING_AGREEMENT_PROCESS_URL);
        }
    }
}

