package com.paypal.hybris.addon.controllers.pages;

import com.paypal.hybris.addon.controllers.PaypaladdonControllerConstants;
import com.paypal.hybris.addon.model.PayPalCreditMessageComponentModel;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalButtonRenderDecisionMakerFacade;
import de.hybris.platform.addonsupport.interceptors.BeforeViewHandlerAdaptee;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.UserFacade;
import org.springframework.ui.ModelMap;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYMENT_INFOS;

public class PayPalBeforeViewHandler implements BeforeViewHandlerAdaptee {

    private static final String B2C_ADD_TO_CART_POPUP_PAGE = "fragments/cart/addToCartPopup";
    private static final String B2C_CART_PAGE = "pages/cart/cartPage";
    private static final String B2C_SILENT_ORDER_POST_PAGE = "pages/checkout/multi/silentOrderPostPage";
    private static final String B2C_CHECKOUT_SUMMARY_PAGE = "pages/checkout/multi/checkoutSummaryPage";
    private static final String B2C_CHECKOUT_CONFIRMATION_PAGE = "pages/checkout/checkoutConfirmationPage";
    private static final String ACCOUNT_LAYOUT_PAGE = "pages/account/accountLayoutPage";
    private static final String EXPRESS_CHECKOUT_COMPONENT = "expressCheckoutComponent";
    private static final String BILLING_AGREEMENT_POSSIBLE = "isBillingAgreementFlow";
    private static final String BILLING_AGREEMENT = "isBillingAgreement";
    private static final String PICKUP_IN_STORE_FLOW = "isPickupInStoreFlow";
    private static final String CART_DATA_TOTAL_PRICE = "cartDataTotalPrice";
    private static final String PAYPAL_CART_PAGE_CREDIT_MESSAGE_COMPONENT = "PayPalCartPageCreditMessageComponent";
    private static final String CREDIT_MESSAGE_COMPONENT = "creditMessageComponent";
    private static final String IS_CREDIT_MESSAGE_ENABLED = "isCreditMessagesEnabled";
    private static final String PAYPAL_BUTTON_COMPONENT = "PayPalButtonComponent";
    private static final String PAYPAL_MINI_BUTTON_COMPONENT = "PayPalMiniButtonComponent";
    private static final String PAYPAL_BILLING_AGREEMENT_EXPRESS_CHECKOUT = "PayPalBillingAgreementExpressCheckout";
    private static final String PAYPAL_ENVIRONMENT_TYPE = "environment";
    private static final String BUYER_COUNTRY = "buyerCountry";
    private static final String IS_VENMO_ENABLED = "isVenmoEnabled";
    private static final String IS_PAYLATER_ENABLED_FOR_NON_US_COUNTRIES = "isPayLaterForNonUsCountriesEnabled";
    private static final String NON_DECIMAL_CURRENCY = "nonDecimalCurrency";
    private static final String PAYPAL_EXPRESS_CHECKOUT_ENABLED = "isExpressCheckoutEnabled";
    private static final String SHOULD_VENMO_DISPLAYED ="shouldVenmoDisplayed";

    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    @Resource(name = "payPalButtonRenderDecisionMakerFacade")
    private DefaultPayPalButtonRenderDecisionMakerFacade decisionMakerFacade;

    @Resource(name = "payPalConfigurationService")
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;

    @Override
    public String beforeView(HttpServletRequest request, HttpServletResponse response, ModelMap model, String viewName)
        throws Exception {
        model.addAttribute(IS_VENMO_ENABLED, defaultPayPalConfigurationService.isVenmoEnabled());
        model.addAttribute(IS_PAYLATER_ENABLED_FOR_NON_US_COUNTRIES,
            defaultPayPalConfigurationService.isPayLaterEnabledForNonUsCountries());
        model.addAttribute(PAYPAL_ENVIRONMENT_TYPE, defaultPayPalConfigurationService.getEnvironmentType());
        model.addAttribute(BUYER_COUNTRY, defaultPayPalConfigurationService.getBuyerCountry());
        model.addAttribute(SHOULD_VENMO_DISPLAYED,
                defaultPayPalConfigurationService.isVenmoEnabled() && !defaultPayPalConfigurationService.isBillingAgreementEnabled());

        if (B2C_SILENT_ORDER_POST_PAGE.equals(viewName)) {
            final List<CCPaymentInfoData> ccPaymentInfos = userFacade.getCCPaymentInfos(true);
            model.addAttribute(PAYMENT_INFOS, ccPaymentInfos);
            model.addAttribute(BILLING_AGREEMENT_POSSIBLE, decisionMakerFacade.isMarkCheckoutBillingAgreementFlow());
            model.addAttribute(BILLING_AGREEMENT, defaultPayPalConfigurationService.isBillingAgreementEnabled());
            model.addAttribute(PICKUP_IN_STORE_FLOW, checkoutFacade.isPickupInStore());
            return PaypaladdonControllerConstants.Views.Pages.MultiStepCheckout.SILENT_ORDER_POST_PAGE;
        } else if (B2C_CHECKOUT_SUMMARY_PAGE.equals(viewName)) {
            return PaypaladdonControllerConstants.Views.Pages.MultiStepCheckout.CHECKOUT_SUMMARY_PAGE;
        } else if (B2C_CHECKOUT_CONFIRMATION_PAGE.equals(viewName)) {
            return PaypaladdonControllerConstants.Views.Pages.Checkout.CHECKOUT_CONFIRMATION_PAGE;
        } else if (B2C_ADD_TO_CART_POPUP_PAGE.equals(viewName)) {
            addExpressCheckoutComponent(model, viewName);
            model.addAttribute(CART_DATA_TOTAL_PRICE, cartFacade.getMiniCart().getTotalPriceWithTax());
            model.addAttribute(NON_DECIMAL_CURRENCY, defaultPayPalConfigurationService.getNonDecimalCurrency());
            return PaypaladdonControllerConstants.Views.Fragments.Cart.ADD_TO_CART_POPUP;
        } else if (B2C_CART_PAGE.equals(viewName)) {
            addExpressCheckoutComponent(model, viewName);
            final PayPalCreditMessageComponentModel creditMessageComponent = cmsComponentService
                .getSimpleCMSComponent(PAYPAL_CART_PAGE_CREDIT_MESSAGE_COMPONENT);
            model.addAttribute(CREDIT_MESSAGE_COMPONENT, creditMessageComponent);
            model.addAttribute(IS_CREDIT_MESSAGE_ENABLED,
                creditMessageComponent.getEnabled() && !defaultPayPalConfigurationService.isBillingAgreementEnabled());
        } else if (ACCOUNT_LAYOUT_PAGE.equals(viewName)) {
            model.addAttribute(BILLING_AGREEMENT_POSSIBLE,
                defaultPayPalConfigurationService.isBillingAgreementEnabled());
            return ACCOUNT_LAYOUT_PAGE;
        }
        model.addAttribute(NON_DECIMAL_CURRENCY, defaultPayPalConfigurationService.getNonDecimalCurrency());
        return viewName;
    }

    private void addExpressCheckoutComponent(final ModelMap model, final String viewName)
        throws CMSItemNotFoundException {
        final String componentName =
            B2C_CART_PAGE.equalsIgnoreCase(viewName) ? PAYPAL_BUTTON_COMPONENT : PAYPAL_MINI_BUTTON_COMPONENT;
        final SimpleCMSComponentModel payPalButtonComponent = cmsComponentService
            .getSimpleCMSComponent(componentName);
        final SimpleCMSComponentModel payPalExpressCheckoutComponent = cmsComponentService
            .getSimpleCMSComponent(PAYPAL_BILLING_AGREEMENT_EXPRESS_CHECKOUT);
        model.addAttribute(EXPRESS_CHECKOUT_COMPONENT,
            decisionMakerFacade.isExpressCheckoutStaticImageFlow(cartFacade.getSessionCart()) ?
                payPalExpressCheckoutComponent : payPalButtonComponent);
        model.addAttribute(BILLING_AGREEMENT_POSSIBLE, decisionMakerFacade.isExpressCheckoutBillingAgreementFlow());
        model.addAttribute(PICKUP_IN_STORE_FLOW, checkoutFacade.isPickupInStore());
        model.addAttribute(PAYPAL_EXPRESS_CHECKOUT_ENABLED,
            defaultPayPalConfigurationService.isExpressCheckoutEnabled());
    }
}
