package com.paypal.hybris.addon.controllers.pages;

import com.paypal.hybris.data.PayPalBillingAgreementData;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalGuestCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractPageController;
import de.hybris.platform.acceleratorstorefrontcommons.security.GUIDCookieStrategy;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.CHECKOUT_MULTI_CONFIRMATION_PAGE;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ORDER_ID_PLACEHOLDER;


@Controller
@RequestMapping(value = "/paypal/billing-agreement/checkout")
public class BillingAgreementController extends AbstractPageController {

    private static final String ANONYMOUS_USER_UID = "anonymous";


    private static final String REDIRECT_TO_MULTISTEP_CHECKOUT_CONFIRMATION =
        REDIRECT_PREFIX + CHECKOUT_MULTI_CONFIRMATION_PAGE;
    private static final String IS_SAVE_PAYMENT_INFO = "isSavePaymentInfo";
    private static final String FUNDING_PARAMETER = "funding";

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    @Resource(name = "guidCookieStrategy")
    private GUIDCookieStrategy guidCookieStrategy;

    @Resource(name = "payPalGuestCheckoutFacade")
    private PayPalGuestCheckoutFacade payPalGuestCheckoutFacade;


    @RequestMapping(value = "/create-token")
    public ResponseEntity<String> getBillingAgreementToken(final HttpServletRequest request,
        final HttpServletResponse response) {
        final boolean skipShipping = !checkoutFacade.hasNoDeliveryAddress();
        return ResponseEntity.ok(checkoutFacade.createBillingAgreementToken(skipShipping));
    }

    @RequestMapping(value = "/response")
    public ResponseEntity<String> doHandleBillingAgreementHopResponse(final HttpServletRequest request,
        final HttpServletResponse response) {
        final String billingAgreementToken = request.getParameter(PAY_PAL_REQUEST_BILLING_AGREEMENT_TOKEN);
        final String isSavePaymentInfo = request.getParameter(IS_SAVE_PAYMENT_INFO);
        final String paymentMethodType = request.getParameter(FUNDING_PARAMETER);
        final PayPalBillingAgreementData billingAgreement = checkoutFacade
            .createBillingAgreement(billingAgreementToken);
        if (ANONYMOUS_USER_UID.equals(checkoutFacade.getCurrentSessionUserUid())) {
            payPalGuestCheckoutFacade.processCheckoutForAnonymous(billingAgreement.getShippingAddress());
            guidCookieStrategy.setCookie(request, response);
        }
        final CCPaymentInfoData payPalPaymentSubscription = checkoutFacade
            .createPayPalPaymentSubscription(billingAgreement, PAYPAL_ORDER_ID_PLACEHOLDER,
                Boolean.valueOf(isSavePaymentInfo), paymentMethodType);
        checkoutFacade.setPaymentDetails(payPalPaymentSubscription.getId());
        checkoutFacade.updateCheckoutPaymentInfoOrderId(PAYPAL_ORDER_ID_PLACEHOLDER);
        return ResponseEntity.ok(CHECKOUT_MULTI_CONFIRMATION_PAGE);
    }

    @RequestMapping(value = "/express")
    public String processBillingAgreementExpressCheckout(final HttpServletRequest request,
        final HttpServletResponse response) {
        checkoutFacade.processBillingAgreementExpressCheckout();
        return REDIRECT_TO_MULTISTEP_CHECKOUT_CONFIRMATION;
    }
}
