package com.paypal.hybris.addon.controllers.cms;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MINI_CART;

import com.paypal.hybris.addon.controllers.PaypaladdonControllerConstants;
import com.paypal.hybris.addon.model.PayPalCreditMessageComponentModel;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalButtonRenderDecisionMakerFacade;
import de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MINI_CART;

@Controller("PayPalCreditMessageComponentController")
@Scope("tenant")
@RequestMapping(value = PaypaladdonControllerConstants.Actions.Cms.PAYPAL_CREDIT_MESSAGE_COMPONENT)
public class PayPalCreditMessageComponentController extends
    AbstractCMSAddOnComponentController<PayPalCreditMessageComponentModel> {

    private static final String TOTAL_PRICE = "totalPrice";
    private static final String CLIENT_ID = "clientID";
    private static final String CART_DATA = "cartData";
    private static final String IS_CREDIT_MESSAGE_ENABLED = "isCreditMessagesEnabled";
    private static final String INTENT = "intent";
    private static final String IS_BILLING_AGREEMENT_FLOW = "isBillingAgreementFlow";
    private static final String IS_PICKUP_IN_STORE_FLOW = "isPickupInStoreFlow";
    private static final String PAYPAL_SDK_URL = "paypalSDKUrl";
    private static final String PARTNER_ATTRIBUTION_ID = "partnerAttributionId";
    private static final String DISABLE_FUNDING = "disableFunding";
    private static final String BUYER_COUNTRY = "buyerCountry";
    private static final String PAYPAL_ENVIRONMENT_TYPE = "environment";

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    @Resource(name = "payPalConfigurationService")
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;

    @Resource(name = "payPalButtonRenderDecisionMakerFacade")
    private DefaultPayPalButtonRenderDecisionMakerFacade decisionMakerFacade;

    @Resource(name = "payPalCheckoutFacade")
    private PayPalCheckoutFacade checkoutFacade;

    /*
     * (non-Javadoc)
     *
     * @see
     * de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController#fillModel(javax.servlet.http
     * .HttpServletRequest, org.springframework.ui.Model,
     * de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel)
     */
    @Override
    protected void fillModel(final HttpServletRequest request, final Model model,
        final PayPalCreditMessageComponentModel component) {
        final CartData cartData = cartFacade.getMiniCart();
        model.addAttribute(TOTAL_PRICE, cartData.getTotalPrice());
        model.addAttribute(CLIENT_ID, defaultPayPalConfigurationService.getClientID());
        model.addAttribute(CART_DATA, cartData);
        model.addAttribute(IS_CREDIT_MESSAGE_ENABLED,
            component.getEnabled() && !defaultPayPalConfigurationService.isBillingAgreementEnabled());
        model.addAttribute(INTENT, defaultPayPalConfigurationService.getPayPalIntent());
        model.addAttribute(IS_BILLING_AGREEMENT_FLOW, decisionMakerFacade.isExpressCheckoutBillingAgreementFlow());
        model.addAttribute(IS_PICKUP_IN_STORE_FLOW, checkoutFacade.isPickupInStore());
        model.addAttribute(PAYPAL_SDK_URL, defaultPayPalConfigurationService.getPayPalSdkJsUrl());
        model.addAttribute(PARTNER_ATTRIBUTION_ID, defaultPayPalConfigurationService.getPayPalPartnerAttributionId());
        model.addAttribute(DISABLE_FUNDING, decisionMakerFacade.getDisableFunding(PAYPAL_DISABLE_FUNDING_MINI_CART));
        model.addAttribute(PAYPAL_ENVIRONMENT_TYPE, defaultPayPalConfigurationService.getEnvironmentType());
        model.addAttribute(BUYER_COUNTRY, defaultPayPalConfigurationService.getBuyerCountry());
    }


    @Override
    @RequestMappingOverride
    @RequestMapping
    public String handleGet(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        return super.handleGet(request, response, model);
    }

}

