package com.paypal.hybris.apitestingservice.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.paypal.hybris.apitestingservice.controller.exception.ApiTestingException;
import com.paypal.hybris.apitestingservice.facades.PropertyUiAutomationFacadeIml;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/property")
public class PropertyController {

    private static final Logger LOG = Logger.getLogger(PropertyController.class);

    @Autowired
    private PropertyUiAutomationFacadeIml propertyUiAutomationFacadeIml;

    @PostMapping(value = "/requireBillingAddress")
    public Boolean setRequireBillingAddress(@RequestBody final String propertyValue) throws ApiTestingException {
        return propertyUiAutomationFacadeIml.setRequireBillingAddress(propertyValue);
    }

    @PostMapping(value = "/addressOverride")
    public Boolean setExpressCheckoutAddressOverride(@RequestBody final String propertyValue)
        throws ApiTestingException {
        return propertyUiAutomationFacadeIml.setExpressCheckoutAddressOverride(propertyValue);
    }

    /**
     * @deprecated      
     */
    @Deprecated
    @PostMapping(value = "/paypalButtonCustomConfig/delete")
    public Boolean deletePayPalButtonCustomConfig() throws ApiTestingException {
        return propertyUiAutomationFacadeIml.deletePayPalButtonCustomConfig();
    }

    @PostMapping(value = "/set")
    public Boolean setProperty(@RequestBody final Map<String, String> propertyMap) throws ApiTestingException {
        LOG.info("propertyMap: " + propertyMap);
        propertyUiAutomationFacadeIml.setPropertyMap(propertyMap);

        return Boolean.TRUE;
    }

    @PostMapping(value = "/setValue")
    public Boolean setProperty(@RequestBody final String propertyString) throws ApiTestingException {
        LOG.info("propertyString: " + propertyString);

        final ObjectMapper mapper = new ObjectMapper();
        Map<String, String> map = new HashMap<>();

        try {
//            convert JSON string to Map
            map = mapper.readValue(propertyString, new TypeReference<Map<String, String>>() {
            });
            propertyUiAutomationFacadeIml.setPropertyMap(map);
        } catch (final Exception e) {
            LOG.error("Exception message: " + e.getMessage(), e);
            return Boolean.FALSE;
        }

        return Boolean.TRUE;
    }

}
