package com.paypal.hybris.apitestingservice.controller;

import com.paypal.hybris.apitestingservice.controller.exception.ApiTestingException;
import de.hybris.platform.promotionengineservices.model.PromotionSourceRuleModel;
import de.hybris.platform.ruleengineservices.enums.RuleStatus;
import de.hybris.platform.ruleengineservices.maintenance.RuleCompilerPublisherResult;
import de.hybris.platform.ruleengineservices.maintenance.RuleMaintenanceService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/promotion")
public class PromotionController {

    private static final Logger LOG = Logger
        .getLogger(com.paypal.hybris.apitestingservice.controller.PromotionController.class);
    private static final String PROMOTIONS_MODULE = "promotions-module";

    @Autowired
    FlexibleSearchService flexibleSearchService;
    @Autowired
    private RuleMaintenanceService ruleMaintenanceService;
    @Autowired
    ModelService modelService;


    @PostMapping(value = "/publish/byCode")
    public boolean publish(@RequestBody final String ruleCode) throws ApiTestingException {
        final List<PromotionSourceRuleModel> rules = new ArrayList<>();
        rules.add(getPromotionRule(ruleCode));

        RuleCompilerPublisherResult result = ruleMaintenanceService
            .compileAndPublishRules(rules, PROMOTIONS_MODULE, false);
        LOG.info("result: " + result.getResult());
        LOG.info(
            "compilerResults: " + result.getCompilerResults() + ", publisherResults: " + result.getPublisherResults());
        return true;
    }

    @PostMapping(value = "/undeploy/all")
    public boolean undeployAll(@RequestBody final String body) throws ApiTestingException {
        if (!body.contains("SecretToken-5354377033")) {
            return false;
        }
        PromotionSourceRuleModel promotionRule = new PromotionSourceRuleModel();
        promotionRule.setStatus(RuleStatus.PUBLISHED);
        List<PromotionSourceRuleModel> rules = flexibleSearchService.getModelsByExample(promotionRule);

        LOG.info("Undeploy all Promotion Rules from 'promotions-module'.");
        ruleMaintenanceService.undeployRules(rules, "promotions-module");

        LOG.info("Undeploy all Promotion Rules from 'promotions-preview-module'.");
        ruleMaintenanceService.undeployRules(rules, "promotions-preview-module");
        return true;
    }

    protected PromotionSourceRuleModel getPromotionRule(final String code) {
        final PromotionSourceRuleModel sample = new PromotionSourceRuleModel();
        sample.setCode(code);
        final PromotionSourceRuleModel model = flexibleSearchService.getModelByExample(sample);
        modelService.refresh(model);
        return model;
    }
}
