package com.paypal.hybris.apitestingservice.controller;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.paypal.hybris.apitestingservice.AddressDTO;
import com.paypal.hybris.apitestingservice.beans.PaymentTransactionBean;
import com.paypal.hybris.apitestingservice.controller.exception.ApiTestingException;
import com.paypal.hybris.apitestingservice.facades.OrderUiAutomationFacadeIml;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;


@RestController
@RequestMapping("/order")
public class OrderController {

    @Autowired
    private OrderUiAutomationFacadeIml orderUiAutomationFacade;

    @RequestMapping(value = "/rma", method = RequestMethod.POST)
    public String getOrderRMA(@RequestBody final String orderID) throws ApiTestingException {
        return new Gson().toJson(orderUiAutomationFacade.getRMA(orderID));
    }

    @RequestMapping(value = "/address", method = RequestMethod.POST)
    public AddressDTO getOrderAddres(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getAddress(orderID);
    }

    @RequestMapping(value = "/lastOrderIdPlacedByUID", method = RequestMethod.POST)
    public String getOrderStatusForUserWhereUidContains(@RequestBody final String UID) throws ApiTestingException {
        return orderUiAutomationFacade.getOrderIdByUID(UID);
    }

    @RequestMapping(value = "/totalPrice", method = RequestMethod.POST)
    public Double getOrderTotalPrice(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getTotalPrice(orderID);
    }

    @RequestMapping(value = "/deliveryCost", method = RequestMethod.POST)
    public Double getOrderDeliveryCost(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getDeliveryCost(orderID);
    }

    @RequestMapping(value = "/totalDiscount", method = RequestMethod.POST)
    public Double getOrderDiscountsIncluded(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getTotalDiscount(orderID);
    }

    @RequestMapping(value = "/addressBook", method = RequestMethod.POST)
    public String getAddresFromAddressBook(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getAddressFromAddressBook(orderID);
    }

    @RequestMapping(value = "/deliveryMode", method = RequestMethod.POST)
    public String getDeliveryMode(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getDeliveryMode(orderID);
    }

    @RequestMapping(value = "/authorizationPaymentTransactions", method = RequestMethod.POST)
    public String getAuthorizationPaymentTransactions(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getAuthorizationPaymentTransactions(orderID);
    }

    @RequestMapping(value = "/capturePaymentTransactionsStatus", method = RequestMethod.POST)
    public String getCapturePaymentTransactions(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getCapturePaymentTransactionsStatusDetails(orderID);
    }

    @RequestMapping(value = "/capturedAmount", method = RequestMethod.POST)
    public String getCapturedAmount(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getCapturedAmount(orderID);
    }

    @RequestMapping(value = "/orderStatus", method = RequestMethod.POST)
    public String getOrderStatus(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getOrderStatus(orderID);
    }
//
//    @RequestMapping(value = "/orderPaymentTransactions", method = RequestMethod.POST)
//    public String getOrderPaymentTransactions(@RequestBody final String orderID) throws ApiTestingException {
//        return orderUiAutomationFacade.getOrderPaymentTransactions(orderID);
//    }

    @RequestMapping(value = "/authorizedAmounts/list", method = RequestMethod.POST)
    public String getAuthorizedAmountsArray(@RequestBody final String orderID) throws ApiTestingException {
        return new Gson().toJson(orderUiAutomationFacade.getAuthorizedAmountsList(orderID));
    }

    @RequestMapping(value = "/authorizationTransactions/list", method = RequestMethod.POST)
    public String getAuthorizationTransactionsList(@RequestBody final String orderID) throws ApiTestingException {
        Type type = new TypeToken<ArrayList<PaymentTransactionBean>>() {
        }.getType();
        return new Gson().toJson(orderUiAutomationFacade.getAuthorizationTransactions(orderID), type);
    }

    @RequestMapping(value = "/captureTransactions/list", method = RequestMethod.POST)
    public String getCaptureTransactionsList(@RequestBody final String orderID) throws ApiTestingException {
        Type type = new TypeToken<ArrayList<PaymentTransactionBean>>() {
        }.getType();
        return new Gson().toJson(orderUiAutomationFacade.getCaptureTransactions(orderID), type);
    }

    @RequestMapping(value = "/voidedAmounts/list", method = RequestMethod.POST)
    public String getVoidedAmountsArray(@RequestBody final String orderID) throws ApiTestingException {
        return new Gson().toJson(orderUiAutomationFacade.getVoidedAmountsList(orderID));
    }

    @RequestMapping(value = "/capturedAmounts/list", method = RequestMethod.POST)
    public String getCapturedAmountsArray(@RequestBody final String orderID) throws ApiTestingException {
        return new Gson().toJson(orderUiAutomationFacade.getCapturedAmountsList(orderID));
    }

    @RequestMapping(value = "/doCapture", method = RequestMethod.POST)
    public boolean doCapture(@RequestBody final Map<String, String> keyValueMap) throws ApiTestingException {
        return orderUiAutomationFacade.doCapture(keyValueMap);
    }

    @RequestMapping(value = "/doAuthorize", method = RequestMethod.POST)
    public boolean doAuthorize(@RequestBody final Map<String, String> keyValueMap) throws ApiTestingException {
        return orderUiAutomationFacade.doAuthorize(keyValueMap);
    }

    @RequestMapping(value = "/doReauthorize", method = RequestMethod.POST)
    public boolean doReauthorize(@RequestBody final Map<String, String> keyValueMap) throws ApiTestingException {
        return orderUiAutomationFacade.doReauthorize(keyValueMap);
    }

    @RequestMapping(value = "/doRefund", method = RequestMethod.POST)
    public boolean doReturn(@RequestBody final Map<String, String> keyValueMap) throws ApiTestingException {
        return orderUiAutomationFacade.doReturn(keyValueMap);
    }

    @RequestMapping(value = "/doVoid", method = RequestMethod.POST)
    public boolean doVoid(@RequestBody final Map<String, String> keyValueMap) throws ApiTestingException {
        return orderUiAutomationFacade.doCancel(keyValueMap);
    }

    @RequestMapping(value = "/refundedAmounts/list", method = RequestMethod.POST)
    public String getRefundedAmountsArray(@RequestBody final String orderID) throws ApiTestingException {
        return new Gson().toJson(orderUiAutomationFacade.getRefundedAmountsList(orderID));
    }

    /*
        @RequestMapping(value = "/doAuthorize", method = RequestMethod.POST)
        public boolean doAuthorize(@RequestBody final Map<String,String> keyValueMap) throws ApiTestingException {
            return orderUiAutomationFacade.doAuthorize(keyValueMap);
        }

        @RequestMapping(value = "/doCapture", method = RequestMethod.POST)
        public boolean doCapture(@RequestBody final Map<String,String> keyValueMap) throws ApiTestingException {
            return orderUiAutomationFacade.doCapture(keyValueMap);
        }

        @RequestMapping(value = "/doVoid", method = RequestMethod.POST)
        public boolean doVoid(@RequestBody final Map<String,String> keyValueMap) throws ApiTestingException {
            return orderUiAutomationFacade.doVoid(keyValueMap);
        }

        @RequestMapping(value = "/doVoidOrder", method = RequestMethod.POST)
        public boolean doVoid(@RequestBody final String orderID) throws ApiTestingException {
            return orderUiAutomationFacade.doVoidOrder(orderID);
        }

        @RequestMapping(value = "/doRefund", method = RequestMethod.POST)
        public boolean doRefund(@RequestBody final Map<String,String> keyValueMap) throws ApiTestingException {
            return orderUiAutomationFacade.doRefund(keyValueMap.get("orderID"), keyValueMap.get("amount"), keyValueMap.get("completeType"));
        }
    */
    @RequestMapping(value = "/user/email", method = RequestMethod.POST)
    public String getUserEmail(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getUserEmail(orderID);
    }
//
//    @RequestMapping(value = "/isValidTransactionId", method = RequestMethod.POST)
//    public boolean isValidTransactionId(@RequestBody Map<String,String> keyValueMap) throws ApiTestingException {
//        return orderUiAutomationFacade.isValidTransactionId(keyValueMap.get("orderID"), keyValueMap.get("transactionId"));
//    }

    @RequestMapping(value = "/getAuthorizationId", method = RequestMethod.POST)
    public String getAuthorizationId(@RequestBody final String orderID) throws ApiTestingException {
        return orderUiAutomationFacade.getLastAuthorizationId(orderID);
    }
}
