package com.paypal.hybris.apitestingservice.controller;

import com.paypal.hybris.apitestingservice.controller.exception.ApiTestingException;
import de.hybris.platform.servicelayer.impex.ImportConfig;
import de.hybris.platform.servicelayer.impex.ImportResult;
import de.hybris.platform.servicelayer.impex.ImportService;
import de.hybris.platform.servicelayer.impex.impl.StreamBasedImpExResource;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.servicelayer.user.UserService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.ByteArrayInputStream;

@RestController
@RequestMapping("/impex")
public class ImpexController {

    private static final Logger LOG = Logger.getLogger(ImpexController.class);

    private static final int DEFAULT_MAX_THREADS = 16;

    @Autowired
    private UserService userService;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private ImportService importService;


    @RequestMapping(value = "/import", method = RequestMethod.POST)
    public Boolean importImpex(@RequestBody final byte[] data) throws ApiTestingException {
        LOG.info("Received data with size: " + data.length + " bytes");

        userService.setCurrentUser(userService.getAdminUser());
//        LOG.info("---> " + sessionService.getCurrentSession().getAllAttributes());

        ImportConfig config = createImportConfig(data, DEFAULT_MAX_THREADS);

//        LOG.info("Importing started");
        final long start = System.currentTimeMillis();

        ImportResult importResult = importService.importData(config);

        final long end = System.currentTimeMillis();
        final long ms = end - start;
//        final double seconds = ms / 1000.0;

        LOG.info("Importing has running for: " + ms + " ms, isSuccessful: " + importResult.isSuccessful());
        if (LOG.isDebugEnabled()) {
            LOG.debug("isFinished: " + importResult.isFinished());
            LOG.debug("isError: " + importResult.isError());
            LOG.debug("isRunning: " + importResult.isRunning());
        }

        return new Boolean(importResult.isSuccessful());
    }

    private ImportConfig createImportConfig(final byte[] data, final int maxThreads) {
        ImportConfig config = new ImportConfig();
        config.setMaxThreads(maxThreads);
        config.setSynchronous(true);
        config.setLegacyMode(Boolean.FALSE);
        config.setValidationMode(ImportConfig.ValidationMode.RELAXED);
        config.setScript(new StreamBasedImpExResource(new ByteArrayInputStream(data), "UTF-8"));
        config.setEnableCodeExecution(Boolean.TRUE);
        return config;
    }
}
