/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.paypal.hybris.apitestingservice.controller;

import static com.paypal.hybris.apitestingservice.constants.ApitestingserviceConstants.PLATFORM_LOGO_CODE;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.paypal.hybris.apitestingservice.service.ApitestingserviceService;


@Controller
public class ApitestingserviceHelloController {

    private static final String LOGO_URL = "logoUrl";
    private static final String WELCOME = "welcome";
    @Autowired
    private ApitestingserviceService apitestingserviceService;

    @RequestMapping(value = "/", method = RequestMethod.GET)
    public String printWelcome(final ModelMap model) {
        model.addAttribute(LOGO_URL, apitestingserviceService.getHybrisLogoUrl(PLATFORM_LOGO_CODE));
        return WELCOME;
    }
}
