/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.paypal.hybris.apitestingservice.setup;

import static com.paypal.hybris.apitestingservice.constants.ApitestingserviceConstants.PLATFORM_LOGO_CODE;

import de.hybris.platform.core.initialization.SystemSetup;

import java.io.InputStream;

import com.paypal.hybris.apitestingservice.constants.ApitestingserviceConstants;
import com.paypal.hybris.apitestingservice.service.ApitestingserviceService;


@SystemSetup(extension = ApitestingserviceConstants.EXTENSIONNAME)
public class ApitestingserviceSystemSetup {

    private final ApitestingserviceService apitestingserviceService;

    public ApitestingserviceSystemSetup(final ApitestingserviceService apitestingserviceService) {
        this.apitestingserviceService = apitestingserviceService;
    }

    @SystemSetup(process = SystemSetup.Process.INIT, type = SystemSetup.Type.ESSENTIAL)
    public void createEssentialData() {
        apitestingserviceService.createLogo(PLATFORM_LOGO_CODE);
    }

    private InputStream getImageStream() {
        return ApitestingserviceSystemSetup.class.getResourceAsStream("/apitestingservice/sap-hybris-platform.png");
    }
}
